#ifndef _OGDXUT_H
#define _OGDXUT_H

// Copyright (c) OpenMedia Lab., 2003. ver.8/31/2003

#pragma comment (lib, "d3d9.lib")
#pragma comment (lib, "d3dx9.lib")
#pragma comment (lib, "dinput8.lib")
#pragma comment (lib, "dxguid.lib")
#pragma comment (lib, "dxerr9.lib")

#include <stdio.h>
#include <tchar.h>
#include <Windowsx.h>

#include <d3dx9.h>
#include <D3DX9Math.h>
#include <dinput.h>
#include <dxerr9.h>

class ogDIDevice{
public:
IDirectInputDevice8 *p;
DIDEVCAPS caps;
IDirectInputEffect *pEffect;
DIJOYSTATE2 state;
	ogDIDevice(){ p = NULL; }
	void release(){
		if(p == NULL) return;
		if(caps.dwFlags & DIDC_FORCEFEEDBACK) pEffect->Release();
		p->Unacquire();
		p->Release();
	}
	bool update();
};

bool ogDIDevice::update(){
	if(p == NULL) return false;
	if(p->Poll() != DI_OK) p->Acquire();
	if(p->GetDeviceState(sizeof(DIJOYSTATE2), &state) == DI_OK){
		return true;
	}else{
		p->Acquire();
		return false;
	}
}

class ogDirectInput{
public:
IDirectInput8 *pDI;
int deviceCount;
ogDIDevice device[8];

	bool begin(HWND hWnd, HINSTANCE hInst);
	void end(){ for(int i=0; i<deviceCount; i++) device[i].release(); if(pDI != NULL) pDI->Release(); }
	bool update(){ for(int i=0; i<deviceCount; i++) if(device[i].update()==false) return false; return true; }
	BOOL callback(const DIDEVICEINSTANCE* pInstance, VOID* pContext);
	BOOL objCallback(const DIDEVICEOBJECTINSTANCE*  pInstance, VOID* pContext);
};
ogDirectInput DirectInput;

BOOL CALLBACK DICallback(const DIDEVICEINSTANCE* pInstance, VOID* pContext){ return DirectInput.callback(pInstance, pContext); }
BOOL CALLBACK DIObjCallback(const DIDEVICEOBJECTINSTANCE*  pInstance, VOID* pContext){ return DirectInput.objCallback(pInstance, pContext); }

BOOL ogDirectInput::callback(const DIDEVICEINSTANCE* pInstance, VOID* pContext){
	if( pDI->CreateDevice(pInstance->guidInstance, &device[deviceCount].p, NULL) != DI_OK ) return DIENUM_STOP;

	device[deviceCount].caps.dwSize = sizeof(DIDEVCAPS);
	if( device[deviceCount].p->GetCapabilities(&device[deviceCount].caps) != DI_OK ){
		device[deviceCount].p->Release();
	}else{
		deviceCount++;
	}
	return DIENUM_CONTINUE;
}

BOOL ogDirectInput::objCallback(const DIDEVICEOBJECTINSTANCE*  pInstance, VOID* pContext){
    if( pInstance->dwType & DIDFT_AXIS ){
        DIPROPRANGE diprg; 
        diprg.diph.dwSize       = sizeof(DIPROPRANGE); 
        diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER); 
        diprg.diph.dwHow        = DIPH_BYID; 
        diprg.diph.dwObj        = pInstance->dwType; // Specify the enumerated axis
        diprg.lMin              = -1000; 
        diprg.lMax              = +1000; 
		device[(int)pContext].p->SetProperty(DIPROP_RANGE, &diprg.diph);
	}
	return DIENUM_CONTINUE;
}

bool ogDirectInput::begin(HWND hWnd, HINSTANCE hInst){
	if( DirectInput8Create(hInst, DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&pDI, NULL) != DI_OK ){ printf("Error in DirectInput8Create\n"); return false; }
	deviceCount = 0;
	pDI->EnumDevices(DI8DEVCLASS_GAMECTRL, DICallback, NULL, DIEDFL_ATTACHEDONLY);
	printf("deviceCount %d\n",deviceCount);
	for(int i=0; i<deviceCount;i++){
		if( device[i].p->SetDataFormat(&c_dfDIJoystick2) != DI_OK ){ printf("Error in DirectInput->Device->SetDataFormat\n"); return false; }
		if( device[i].p->SetCooperativeLevel(hWnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND) != DI_OK ){ printf("Error in DirectInput->Device->SetCooperativeLevel\n"); return false; }
		if( device[i].p->EnumObjects(DIObjCallback, (void *)i, DIDFT_ALL) != DI_OK ){ printf("Error in DirectInput->Device->EnumObjects\n"); return false; }

		if(device[i].caps.dwFlags & DIDC_FORCEFEEDBACK){
			DIPROPDWORD prop;
			prop.diph.dwSize = sizeof(DIPROPDWORD);
			prop.diph.dwHeaderSize = sizeof(DIPROPHEADER);
			prop.diph.dwObj = 0;
			prop.diph.dwHow = DIPH_DEVICE;
			prop.dwData = DIPROPAUTOCENTER_OFF;
			device[i].p->SetProperty(DIPROP_AUTOCENTER, &prop.diph);
	
			DWORD axes[2] = { DIJOFS_X, DIJOFS_Y };
			LONG  direction[2] = { 0, 0 };
			DIPERIODIC periodic = { DWORD(DI_FFNOMINALMAX*0.3), 0, 0, DWORD(DI_SECONDS*0.2) };
			DIENVELOPE envelope = { sizeof(DIENVELOPE), 0, DWORD(DI_SECONDS*0.05), 0, DWORD(DI_SECONDS*0.05) };
			DIEFFECT   effect = { sizeof(DIEFFECT), DIEFF_CARTESIAN | DIEFF_OBJECTOFFSETS, DWORD(DI_SECONDS * 0.5), 0,
								DI_FFNOMINALMAX, DIEB_NOTRIGGER, 0, 2, axes, direction, &envelope, sizeof(DIPERIODIC), &periodic, 0 };

			device[i].p->CreateEffect( GUID_Sine, &effect, &device[i].pEffect, NULL);
		}
	}
	return true;
}
//--------------------------------------------------------------
class ogDirect3D{
public:
	IDirect3D9 *pD3D;
	IDirect3DDevice9 *pDevice;

	bool begin(HWND hWnd);
	void end(){ if(pDevice != NULL) pDevice->Release(); if(pD3D != NULL) pD3D->Release(); }
};
ogDirect3D Direct3D;

bool ogDirect3D::begin(HWND hWnd){
	if( (pD3D = Direct3DCreate9(D3D_SDK_VERSION)) == NULL ){ printf("Error in Direct3DCreate9\n"); return false; }

	D3DPRESENT_PARAMETERS pp;
	ZeroMemory( &pp, sizeof(pp) );
	pp.Windowed               = TRUE;
	pp.SwapEffect             = D3DSWAPEFFECT_COPY;
	pp.EnableAutoDepthStencil = TRUE;
	pp.AutoDepthStencilFormat = D3DFMT_D16;

	if(pD3D->CreateDevice(D3DADAPTER_DEFAULT,D3DDEVTYPE_HAL,hWnd,D3DCREATE_HARDWARE_VERTEXPROCESSING,&pp,&pDevice) != D3D_OK)
	if(pD3D->CreateDevice(D3DADAPTER_DEFAULT,D3DDEVTYPE_HAL,hWnd,D3DCREATE_SOFTWARE_VERTEXPROCESSING,&pp,&pDevice) != D3D_OK)
	if(pD3D->CreateDevice(D3DADAPTER_DEFAULT,D3DDEVTYPE_REF,hWnd,D3DCREATE_SOFTWARE_VERTEXPROCESSING,&pp,&pDevice) != D3D_OK){
		printf("Error in Direct3D->CreateDevice\n");
		return false;
	}

	return true;
}


#endif  //_OGDXUT_H