#ifndef _OGRENDER_H
#define _OGRENDER_H

// Copyright (c) OpenMedia Lab., 2003. ver.6/17/2004

#ifdef _WIN32
#ifdef __GL_H__
	#pragma comment (lib, "OpenGL32.lib")
	#pragma comment (lib, "GLU32.lib")
#endif

#ifdef _SDL_H
	#pragma comment (lib, "SDL.lib")
	#pragma comment (lib, "SDLmain.lib")
#endif

#pragma warning (disable:4244)
#endif

#include "geometry.h"
#include "bitmap.h"
#include "time.h"
#include "renderx.h"

//-------------------------------------------------------------------------

#ifdef __GLUT_H__
	#define OGK_LBUTTON     GLUT_LEFT_BUTTON
	#define OGK_MBUTTON     GLUT_MIDDLE_BUTTON
	#define OGK_RBUTTON     GLUT_RIGHT_BUTTON
	#define OGK_MOUSE_LEFT   GLUT_LEFT_BUTTON
	#define OGK_MOUSE_MIDDLE GLUT_MIDDLE_BUTTON
	#define OGK_MOUSE_RIGHT  GLUT_RIGHT_BUTTON
	#define OGK_PRESSED     GLUT_DOWN
	#define OGK_RELEASED    GLUT_UP
	#define OGK_KEYPAD0  '0'
	#define OGK_KEYPAD1  '1'
	#define OGK_KEYPAD2  '2'
	#define OGK_KEYPAD3  '3'
	#define OGK_KEYPAD4  '4'
	#define OGK_KEYPAD5  '5'
	#define OGK_KEYPAD6  '6'
	#define OGK_KEYPAD7  '7'
	#define OGK_KEYPAD8  '8'
	#define OGK_KEYPAD9  '9'
	#define OGK_LEFT     GLUT_KEY_LEFT
	#define OGK_UP       GLUT_KEY_UP
	#define OGK_RIGHT    GLUT_KEY_RIGHT
	#define OGK_DOWN     GLUT_KEY_DOWN
	#define OGK_INSERT   GLUT_KEY_INSERT
	#define OGK_HOME     GLUT_KEY_HOME
	#define OGK_END      GLUT_KEY_END
	#define OGK_PAGEUP   GLUT_KEY_PAGE_UP
	#define OGK_PAGEDOWN GLUT_KEY_PAGE_DOWN
	#define OGK_F1       GLUT_KEY_F1
	#define OGK_F2       GLUT_KEY_F2
	#define OGK_F3       GLUT_KEY_F3
	#define OGK_F4       GLUT_KEY_F4
	#define OGK_F5       GLUT_KEY_F5
	#define OGK_F6       GLUT_KEY_F6
	#define OGK_F7       GLUT_KEY_F7
	#define OGK_F8       GLUT_KEY_F8
	#define OGK_F9       GLUT_KEY_F9
	#define OGK_F10      GLUT_KEY_F10
	#define OGK_F11      GLUT_KEY_F11
	#define OGK_F12      GLUT_KEY_F12
#else
	#ifdef _SDL_H
		#define OGK_KEYPAD0     SDLK_KP0
		#define OGK_KEYPAD1     SDLK_KP1
		#define OGK_KEYPAD2     SDLK_KP2
		#define OGK_KEYPAD3     SDLK_KP3
		#define OGK_KEYPAD4     SDLK_KP4
		#define OGK_KEYPAD5     SDLK_KP5
		#define OGK_KEYPAD6     SDLK_KP6
		#define OGK_KEYPAD7     SDLK_KP7
		#define OGK_KEYPAD8     SDLK_KP8
		#define OGK_KEYPAD9     SDLK_KP9
		#define OGK_KP_PERIOD   SDLK_KP_PERIOD
		#define OGK_KP_DIVIDE   SDLK_KP_DIVIDE
		#define OGK_KP_MULTIPLY SDLK_KP_MULTIPLY
		#define OGK_KP_MINUS    SDLK_KP_MINUS
		#define OGK_KP_PLUS     SDLK_KP_PLUS
		#define OGK_KP_ENTER    SDLK_KP_ENTER
		#define OGK_KP_EQUALS   SDLK_KP_EQUALS
		#define OGK_UP          SDLK_UP
		#define OGK_DOWN        SDLK_DOWN
		#define OGK_RIGHT       SDLK_RIGHT
		#define OGK_LEFT        SDLK_LEFT
		#define OGK_INSERT      SDLK_INSERT
		#define OGK_HOME        SDLK_HOME
		#define OGK_END         SDLK_END
		#define OGK_PAGEUP      SDLK_PAGEUP
		#define OGK_PAGEDOWN    SDLK_PAGEDOWN
		#define OGK_F1          SDLK_F1
		#define OGK_F2          SDLK_F2
		#define OGK_F3          SDLK_F3
		#define OGK_F4          SDLK_F4
		#define OGK_F5          SDLK_F5
		#define OGK_F6          SDLK_F6
		#define OGK_F7          SDLK_F7
		#define OGK_F8          SDLK_F8
		#define OGK_F9          SDLK_F9
		#define OGK_F10         SDLK_F10
		#define OGK_F11         SDLK_F11
		#define OGK_F12         SDLK_F12
		#define OGK_F13         SDLK_F13
		#define OGK_F14         SDLK_F14
		#define OGK_F15         SDLK_F15
		#define OGK_NUMLOCK     SDLK_NUMLOCK
		#define OGK_CAPSLOCK    SDLK_CAPSLOCK
		#define OGK_SCROLLOCK   SDLK_SCROLLOCK
		#define OGK_RSHIFT      SDLK_RSHIFT
		#define OGK_LSHIFT      SDLK_LSHIFT
		#define OGK_RCONTROL    SDLK_RCTRL
		#define OGK_LCONTROL    SDLK_LCTRL
		#define OGK_RALT        SDLK_RALT
		#define OGK_LALT        SDLK_LALT
		#define OGK_RMETA       SDLK_RMETA
		#define OGK_LMETA       SDLK_LMETA
		#define OGK_LSUPER      SDLK_LSUPER
		#define OGK_RSUPER      SDLK_RSUPER
		#define OGK_MODE        SDLK_MODE
		#define OGK_COMPOSE     SDLK_COMPOSE
		#define OGK_HELP        SDLK_HELP
		#define OGK_PRINT       SDLK_PRINT
		#define OGK_SYSREQ      SDLK_SYSREQ
		#define OGK_BREAK       SDLK_BREAK
		#define OGK_MENU        SDLK_MENU
		#define OGK_POWER       SDLK_POWER
		#define OGK_EURO        SDLK_EURO
		#define OGK_UNDO        SDLK_UNDO
	#else
		#define OGK_LBUTTON     VK_LBUTTON
		#define OGK_MBUTTON     VK_MBUTTON
		#define OGK_RBUTTON     VK_RBUTTON
		#define OGK_MOUSE_LEFT   VK_LBUTTON
		#define OGK_MOUSE_MIDDLE VK_MBUTTON
		#define OGK_MOUSE_RIGHT  VK_RBUTTON
		#define OGK_PRESSED     1
		#define OGK_RELEASED    0
		#define OGK_KEYPAD0     VK_NUMPAD0
		#define OGK_KEYPAD1     VK_NUMPAD1
		#define OGK_KEYPAD2     VK_NUMPAD2
		#define OGK_KEYPAD3     VK_NUMPAD3
		#define OGK_KEYPAD4     VK_NUMPAD4
		#define OGK_KEYPAD5     VK_NUMPAD5
		#define OGK_KEYPAD6     VK_NUMPAD6
		#define OGK_KEYPAD7     VK_NUMPAD7
		#define OGK_KEYPAD8     VK_NUMPAD8
		#define OGK_KEYPAD9     VK_NUMPAD9
		#define OGK_KP_PERIOD   VK_DECIMAL
		#define OGK_KP_DIVIDE   VK_DIVIDE
		#define OGK_KP_MULTIPLY VK_MULTIPLY
		#define OGK_KP_MINUS    VK_SUBTRACT
		#define OGK_KP_PLUS     VK_ADD
		#define OGK_KP_ENTER    VK_ENTER
		#define OGK_LEFT        VK_LEFT
		#define OGK_UP          VK_UP
		#define OGK_RIGHT       VK_RIGHT
		#define OGK_DOWN        VK_DOWN
		#define OGK_INSERT      VK_INSERT
		#define OGK_HOME        VK_HOME
		#define OGK_END         VK_END
		#define OGK_F1          VK_F1
		#define OGK_F2          VK_F2
		#define OGK_F3          VK_F3
		#define OGK_F4          VK_F4
		#define OGK_F5          VK_F5
		#define OGK_F6          VK_F6
		#define OGK_F7          VK_F7
		#define OGK_F8          VK_F8
		#define OGK_F9          VK_F9
		#define OGK_F10         VK_F10
		#define OGK_F11         VK_F11
		#define OGK_F12         VK_F12
		#define OGK_NUMLOCK     VK_NUMLOCK
		#define OGK_CAPSLOCK    VK_CAPITAL
		#define OGK_SCROLLOCK   VK_SCROLL
		#define OGK_RSHIFT      VK_RSHIFT
		#define OGK_LSHIFT      VK_LSHIFT
		#define OGK_RCONTROL    VK_RCONTROL
		#define OGK_LCONTROL    VK_LCONTROL
		#define OGK_RALT        VK_RMENU
		#define OGK_LALT        VK_LMENU
		#define OGK_MODE        VK_MODECHANGE
		#define OGK_HELP        VK_HELP
		#define OGK_PRINT       VK_PRINT

	#endif
#endif

#define OGK_0 '0'//48
#define OGK_1 '1'
#define OGK_2 '2'
#define OGK_3 '3'
#define OGK_4 '4'
#define OGK_5 '5'
#define OGK_6 '6'
#define OGK_7 '7'
#define OGK_8 '8'
#define OGK_9 '9'
#define OGK_A 'a' //97
#define OGK_B 'b'
#define OGK_C 'c'
#define OGK_D 'd'
#define OGK_E 'e'
#define OGK_F 'f'
#define OGK_G 'g'
#define OGK_H 'h'
#define OGK_I 'i'
#define OGK_J 'j'
#define OGK_K 'k'
#define OGK_L 'l'
#define OGK_M 'm'
#define OGK_N 'n'
#define OGK_O 'o'
#define OGK_P 'p'
#define OGK_Q 'q'
#define OGK_R 'r'
#define OGK_S 's'
#define OGK_T 't'
#define OGK_U 'u'
#define OGK_V 'v'
#define OGK_W 'w'
#define OGK_X 'x'
#define OGK_Y 'y'
#define OGK_Z 'z'
#define OGK_DELETE 127

#define OGK_GPL_LEFT 256
#define OGK_GPL_UP   257
#define OGK_GPL_RIGHT 258
#define OGK_GPL_DOWN 259
#define OGK_GPR_LEFT 260
#define OGK_GPR_UP   261
#define OGK_GPR_RIGHT 262
#define OGK_GPR_DOWN 263
#define OGK_GPT_UPPER_LEFT 264
#define OGK_GPT_UPPER_RIGHT 265
#define OGK_GPT_LOWER_LEFT 266
#define OGK_GPT_LOWER_RIGHT 267

class ogRender{
public:
	//for viewport
	int x;
	int y;
	int width;
	int height;
	//for ortho
	Double left;    
	Double right;   
	Double bottom;  
	Double top;
	//for perspective or frustum
	Double fovy;
	Double nearClip;
	Double farClip;
	Double screenWidth;
	Double screenHeight;
	ogVector screenCenter2eye;
	Double pupilDistance;
	//for lookat
	ogVector  eye;
	ogVector  center;
	ogVector  up;
	ogVector  eye0;
	ogVector  center0;
	ogVector  zenith0;
	//for view change
	Double   angleStep;
	Double   zoomStep;
	Double   slideStep;

	bool keyState[350];
	//for texture
	int textureCount;
	int currentTexture;
	#ifdef __GL_H__
	GLuint *texture;
	#else
	LPDIRECT3DTEXTURE9 *pTexture;
	#endif

	ogRender(){
		int i;
		for(i=0; i<350; i++) keyState[i] = false;
		textureCount = 0;
		currentTexture = -1;
		#ifdef __GL_H__
		#else
		#endif
	}

	double GetFrameInterval(){ return ogGetFrameInterval(); } // time.h
	void PushMatrix(){ ogPushMatrix(); }
	void PopMatrix(){ ogPopMatrix(); }
	void Translate(float x, float y, float z){ ogTranslate(x, y, z); }
	void Rotate(float angle, float x, float y, float z){ ogRotate(angle, x, y, z); }
	void Clear(unsigned char red, unsigned char green, unsigned char blue ){ ogClear(red, green, blue ); }
	void SwapBuffers(){ ogSwapBuffers(); }
	void ZBufferOn(){ ogZBufferOn(); }
	void ZBufferOff(){ ogZBufferOff(); }
	void FlatShading(){ ogFlatShading(); }
	void GouraudShading(){ ogGouraudShading(); }
	void LightPosition(float x, float y, float z){ ogLightPosition(x, y, z); }
	void LightOn(float x, float y, float z, float diffuseRed, float diffuseGreen, float diffuseBlue, float specularRed, float specularGreen, float specularBlue, float ambientRed, float ambientGreen, float ambientBlue, float shininess=10.0){
		ogLightOn(x, y, z, diffuseRed, diffuseGreen, diffuseBlue, specularRed, specularGreen, specularBlue, ambientRed, ambientGreen, ambientBlue, shininess); }
	void LightOff(){ ogLightOff(); }
	void Viewport(int x, int y, int width, int height){ ogViewport(x, y, width, height); this->x = x; this->y = y; this->width = width; this->height = height; }
	void ViewportLeft(){ ogViewport( x, y, width/2, height ); }
	void ViewportRight(){ ogViewport( x+width/2, y, width/2, height ); }
	void ViewportUpper( Double verticalAdjust = 0.0 ){ ogViewport( x, y+(int)verticalAdjust+height/2, width, height/2 ); }
	void ViewportLower( Double verticalAdjust = 0.0 ){ ogViewport( x, y+(int)verticalAdjust, width, height/2 ); }
	void GetViewport(int &x, int &y, int &width, int &height){ ogGetViewport(x,y, width, height); }
	void GetViewport(int &width, int &height){ int x,y; ogGetViewport(x,y, width, height); }
	void Ortho2D( float left, float right, float bottom, float top ){ ogOrtho2D(left, right, bottom, top ); this->left = left; this->right = right; this->bottom = bottom; this->top = top;}
	void Ortho( float left, float right, float bottom, float top ){ this->Ortho2D(left, right, bottom, top ); }
	void Ortho2DPixelScale(){ this->Ortho2D( 0, width, 0, height ); }
	void OrthoPixelScale(){ this->Ortho2DPixelScale(); }
	void ResetLookAtValues(){
		eye = eye0;
		center = center0;
		ogVector viewLine = center - eye;
		ogVector leftDirection = zenith0 & viewLine;
		up = viewLine & leftDirection;
		up.normalize();
	}
	void ResetLookAtValues(float ex, float ey, float ez, float cx, float cy, float cz, float ux, float uy, float uz){
		eye0.set(ex,ey,ez);
		center0.set(cx,cy,cz);
		zenith0.set(ux,uy,uz);
		this->ResetLookAtValues();
	}
	ogVector GetEyePosition(){ return eye; }
	void ExecuteLookAt(){ ogLookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z); }
	void LookAt(float ex, float ey, float ez, float cx, float cy, float cz, float ux, float uy, float uz){ this->ResetLookAtValues(ex,ey,ez,cx,cy,cz,ux,uy,uz); this->ExecuteLookAt(); }
	void LookAt( ogVector &eye, ogVector &center, ogVector &up ){ this->LookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z ); }
	void RotateEyePositionRight( Double angle ){ ogVector viewLine = center - eye; viewLine.rotate( up, angle ); eye = center - viewLine; this->ExecuteLookAt(); }
	void RotateEyePositionLeft( Double angle ){ this->RotateEyePositionRight( -angle ); }
	void RotateEyePositionUp( Double angle );
	void RotateEyePositionDown( Double angle ){ this->RotateEyePositionUp( -angle ); }
	void TwistEyeRight( Double angle ){ ogVector viewLine = center - eye; up.rotate( viewLine, angle ); this->ExecuteLookAt(); }
	void TwistEyeLeft( Double angle ){ this->TwistEyeRight( -angle ); }
	void ZoomUp( Double delta ){ ogVector v=center - eye; v*=delta; eye += v; ExecuteLookAt(); }
	void ZoomDown( Double delta ){ this->ZoomUp( -delta ); }
	void SlideEyePositionRight( Double delta );
	void SlideEyePositionLeft( Double delta ){ this->SlideEyePositionRight( -delta ); }
	void ResetEyePosition(){ this->ResetLookAtValues(); this->ExecuteLookAt(); }
	int  KeyControlEyePosition( Double angle, Double delta );

	void RotateEyePosition( int mouseX, int mouseY ){ ogRotateEyePosition( mouseX, mouseY ); }
	void Perspective(float fovy, float nearClip, float farClip){ ogPerspective(fovy, nearClip, farClip); this->fovy = fovy, this->nearClip = nearClip; this->farClip = farClip; }
	void Window2World( Double windowX, Double windowY, Double windowZ, Double &worldX, Double &worldY, Double &worldZ ){ ogWindow2World(windowX, windowY, windowZ, worldX, worldY, worldZ ); }
	void Window2World( int windowX, int windowY, Double windowZ, Double &worldX, Double &worldY, Double &worldZ ){ ogWindow2World(Double(windowX), Double(windowY), windowZ, worldX, worldY, worldZ ); }
	void Window2World( ogVector &window, Double &worldX, Double &worldY, Double &worldZ ){ this->Window2World( window.x, window.y, window.z, worldX, worldY, worldZ ); }
	void Window2World( Double windowX, Double windowY, Double windowZ, ogVector &world ){ this->Window2World( windowX, windowY, windowZ, world.x, world.y, world.z ); }
	void Window2World( ogVector &window, ogVector &world ){ this->Window2World( window.x, window.y, window.z, world.x, world.y, world.z ); }
	void Window2World( int windowX, int windowY, Double windowZ, ogVector &world ){ this->Window2World( windowX, windowY, windowZ, world.x, world.y, world.z ); }

	void Window2World( Double windowX, Double windowY, Double &worldX, Double &worldY ){ Double worldZ; ogWindow2World( windowX, windowY, 0.0, worldX, worldY, worldZ ); }
	void Window2World( int windowX, int windowY, Double &worldX, Double &worldY ){ Double worldZ; ogWindow2World( Double(windowX), Double(windowY), 0.0, worldX, worldY, worldZ ); }
	void Window2World( Double windowX, Double windowY, ogVector2 &world ){ this->Window2World( windowX, windowY, world.x, world.y ); }
	void Window2World( ogVector2 &window, Double &worldX, Double &worldY ){ this->Window2World( window.x, window.y, worldX, worldY ); }
	void Window2World( int windowX, int windowY, ogVector2 &world ){ this->Window2World( windowX, windowY, world.x, world.y ); }

	void World2Window( Double worldX, Double worldY, Double worldZ, Double &windowX, Double &windowY, Double &windowZ ){ ogWorld2Window(worldX, worldY, worldZ, windowX, windowY, windowZ ); }
	void World2Window( Double worldX, Double worldY, Double worldZ, int &windowX, int &windowY, Double &windowZ ){ Double x, y; this->World2Window( worldX, worldY, worldZ, x, y, windowZ ); windowX = int(x+0.5); windowY = int(y+0.5); }
	void World2Window( ogVector world, Double &windowX, Double &windowY, Double &windowZ ){ ogWorld2Window(world.x, world.y, world.z, windowX, windowY, windowZ ); }
	void World2Window( Double worldX, Double worldY, Double worldZ, ogVector &window ){ ogWorld2Window(worldX, worldY, worldZ, window.x, window.y, window.z ); }
	void World2Window( ogVector world, ogVector &window ){ ogWorld2Window(world.x, world.y, world.z, window.x, window.y, window.z ); }
	void World2Window( ogVector world, int &windowX, int &windowY, Double &windowZ ){ this->World2Window(world.x, world.y, world.z, windowX, windowY, windowZ ); }

	void World2Window( Double worldX, Double worldY, Double &windowX, Double &windowY ){ Double windowZ; ogWorld2Window( worldX, worldY, 0.0, windowX, windowY, windowZ ); }
	void World2Window( Double worldX, Double worldY, int &windowX, int &windowY ){ Double x, y; this->World2Window( worldX, worldY, x, y ); windowX = int(x+0.5); windowY = int(y+0.5); }
	void World2Window( ogVector2 &world, Double &windowX, Double &windowY ){ this->World2Window( world.x, world.y, windowX, windowY ); }
	void World2Window( Double worldX, Double worldY, ogVector2 &window ){ this->World2Window( worldX, worldY, window.x, window.y ); }
	void World2Window( ogVector2 &world, ogVector2 &window ){ this->World2Window( world.x, world.y, window.x, window.y ); }
	void World2Window( ogVector2 &world, int &windowX, int &windowY ){ this->World2Window( world.x, world.y, windowX, windowY ); }
	void Redisplay(){ ogRedisplay(); }
	ogLine CursorLine( int x, int y ){
		ogVector a, b;	
		this->Window2World( x,y, -1.0, a.x, a.y, a.z );
		this->Window2World( x,y,  1.0, b.x, b.y, b.z );
		ogLine line( a, b );
		return line;
	}
	ogLine ViewLine(){ ogLine line; line.direction = center - eye; line.passage = eye; return line; }
	void WarpPointer( int x, int y ){
		#ifdef __GLUT_H__
		glutWarpPointer( x, y );
		#else
		POINT position; position.x = x; position.y = y;
		ClientToScreen( GetActiveWindow(), &position );
		SetCursorPos( position.x, position.y );
		#endif
	}
	void DrawPolygon(ogVFxyzc vertex[], int n){ ogDrawPolygon(vertex, n); }
	void DrawTexturePolygon(ogVFxyzct vertex[], int n){ ogDrawTexturePolygon(vertex,n); }
	void DrawTexturePolygon(ogVFxyzct vertex[], int n, int textureNumber){ this->SetTexture(textureNumber); this->DrawTexturePolygon(vertex, n); }
	void DrawTriangle(Double x1, Double y1, Double z1, unsigned char r1, unsigned char g1, unsigned char b1,
                      Double x2, Double y2, Double z2, unsigned char r2, unsigned char g2, unsigned char b2,
                      Double x3, Double y3, Double z3, unsigned char r3, unsigned char g3, unsigned char b3){
						  ogDrawTriangle(x1,y1,z1,r1,g1,b1,x2,y2,z2,r2,g2,b2,x3,y3,z3,r3,g3,b3); }
	void DrawTriangle(Double x1, Double y1, Double z1, Double x2, Double y2, Double z2, Double x3, Double y3, Double z3, unsigned char red, unsigned char green, unsigned char blue){
						  ogDrawTriangle(x1,y1,z1,red,green,blue,x2,y2,z2,red,green,blue,x3,y3,z3,red,green,blue); }
	void DrawTriangle(Double x1, Double y1, unsigned char r1, unsigned char g1, unsigned char b1,
                      Double x2, Double y2, unsigned char r2, unsigned char g2, unsigned char b2,
                      Double x3, Double y3, unsigned char r3, unsigned char g3, unsigned char b3){
						  ogDrawTriangle(x1,y1,0.0,r1,g1,b1,x2,y2,0.0,r2,g2,b2,x3,y3,0.0,r3,g3,b3); }
	void DrawTriangle(Double x1, Double y1, Double x2, Double y2, Double x3, Double y3, unsigned char red, unsigned char green, unsigned char blue){
						  ogDrawTriangle(x1,y1,0.0,red,green,blue,x2,y2,0.0,red,green,blue,x3,y3,0.0,red,green,blue); }
	void DrawQuad(Double x1, Double y1, Double z1, unsigned char r1, unsigned char g1, unsigned char b1,
                  Double x2, Double y2, Double z2, unsigned char r2, unsigned char g2, unsigned char b2,
                  Double x3, Double y3, Double z3, unsigned char r3, unsigned char g3, unsigned char b3,
                  Double x4, Double y4, Double z4, unsigned char r4, unsigned char g4, unsigned char b4){
						  ogDrawQuad(x1,y1,z1,r1,g1,b1,x2,y2,z2,r2,g2,b2,x3,y3,z3,r3,g3,b3,x4,y4,z4,r4,g4,b4); }
	void DrawQuad(Double x1, Double y1, Double z1, Double x2, Double y2, Double z2, Double x3, Double y3, Double z3, Double x4, Double y4, Double z4, unsigned char red, unsigned char green, unsigned char blue){
						  ogDrawQuad(x1,y1,z1,red,green,blue,x2,y2,z2,red,green,blue,x3,y3,z3,red,green,blue,x4,y4,z4,red,green,blue); }
	void DrawQuad(Double x1, Double y1, unsigned char r1, unsigned char g1, unsigned char b1,
                  Double x2, Double y2, unsigned char r2, unsigned char g2, unsigned char b2,
                  Double x3, Double y3, unsigned char r3, unsigned char g3, unsigned char b3,
                  Double x4, Double y4, unsigned char r4, unsigned char g4, unsigned char b4){
						  ogDrawQuad(x1,y1,0.0,r1,g1,b1,x2,y2,0.0,r2,g2,b2,x3,y3,0.0,r3,g3,b3,x4,y4,0.0,r4,g4,b4); }
	void DrawQuad(Double x1, Double y1, Double x2, Double y2, Double x3, Double y3, Double x4, Double y4, unsigned char red, unsigned char green, unsigned char blue){
						  ogDrawQuad(x1,y1,0.0,red,green,blue,x2,y2,0.0,red,green,blue,x3,y3,0.0,red,green,blue,x4,y4,0.0,red,green,blue); }
	void DrawTextureTriangle(Double x1, Double y1, Double z1, unsigned char r1, unsigned char g1, unsigned char b1, Double u1, Double v1,
                             Double x2, Double y2, Double z2, unsigned char r2, unsigned char g2, unsigned char b2, Double u2, Double v2,
                             Double x3, Double y3, Double z3, unsigned char r3, unsigned char g3, unsigned char b3, Double u3, Double v3, int textureNumber=0){ //24,25
		if(textureNumber != currentTexture) this->SetTexture(textureNumber);
		ogDrawTextureTriangle(x1,y1,z1,r1,g1,b1,u1,v1,x2,y2,z2,r2,g2,b2,u2,v2,x3,y3,z3,r3,g3,b3,u3,v3);
	}
	void DrawTextureTriangle(Double x1, Double y1, Double z1, Double u1, Double v1,
                             Double x2, Double y2, Double z2, Double u2, Double v2,
                             Double x3, Double y3, Double z3, Double u3, Double v3, int textureNumber=0){//15,16
		this->DrawTextureTriangle(x1,y1,z1,255,255,255,u1,v1, x2,y2,z2,255,255,255,u2,v2, x3,y3,z3,255,255,255,u3,v3, textureNumber);
	}
	void DrawTextureTriangle(Double x1, Double y1, unsigned char r1, unsigned char g1, unsigned char b1, Double u1, Double v1,
                             Double x2, Double y2, unsigned char r2, unsigned char g2, unsigned char b2, Double u2, Double v2,
                             Double x3, Double y3, unsigned char r3, unsigned char g3, unsigned char b3, Double u3, Double v3, int textureNumber=0){//21,22
		this->DrawTextureTriangle(x1,y1,0.0,r1,g1,b1,u1,v1,x2,y2,0.0,r2,g2,b2,u2,v2,x3,y3,0.0,r3,g3,b3,u3,v3, textureNumber);
	}
	void DrawTextureTriangle(Double x1, Double y1, Double u1, Double v1,
                             Double x2, Double y2, Double u2, Double v2,
                             Double x3, Double y3, Double u3, Double v3, int textureNumber=0){//12,13
		this->DrawTextureTriangle(x1,y1,255,255,255,u1,v1, x2,y2,255,255,255,u2,v2, x3,y3,255,255,255,u3,v3, textureNumber);
	}
	void DrawTextureQuad(Double x1, Double y1, Double z1, unsigned char r1, unsigned char g1, unsigned char b1, Double u1, Double v1,
                         Double x2, Double y2, Double z2, unsigned char r2, unsigned char g2, unsigned char b2, Double u2, Double v2,
                         Double x3, Double y3, Double z3, unsigned char r3, unsigned char g3, unsigned char b3, Double u3, Double v3,
                         Double x4, Double y4, Double z4, unsigned char r4, unsigned char g4, unsigned char b4, Double u4, Double v4, int textureNumber=0){//32,33
		if(textureNumber != currentTexture) this->SetTexture(textureNumber);
		ogDrawTextureQuad(x1,y1,z1,r1,g1,b1,u1,v1,x2,y2,z2,r2,g2,b2,u2,v2,x3,y3,z3,r3,g3,b3,u3,v3,x4,y4,z4,r4,g4,b4,u4,v4);
	}
	void DrawTextureQuad(Double x1, Double y1, Double z1, Double u1, Double v1,
                         Double x2, Double y2, Double z2, Double u2, Double v2,
                         Double x3, Double y3, Double z3, Double u3, Double v3,
                         Double x4, Double y4, Double z4, Double u4, Double v4, int textureNumber=0){//20,21
		this->DrawTextureQuad(x1,y1,z1,255,255,255,u1,v1, x2,y2,z2,255,255,255,u2,v2, x3,y3,z3,255,255,255,u3,v3, x4,y4,z4,255,255,255,u4,v4, textureNumber);
	}
	void DrawTextureQuad(Double x1, Double y1, unsigned char r1, unsigned char g1, unsigned char b1, Double u1, Double v1,
                         Double x2, Double y2, unsigned char r2, unsigned char g2, unsigned char b2, Double u2, Double v2,
                         Double x3, Double y3, unsigned char r3, unsigned char g3, unsigned char b3, Double u3, Double v3,
                         Double x4, Double y4, unsigned char r4, unsigned char g4, unsigned char b4, Double u4, Double v4, int textureNumber=0){//28,29
		this->DrawTextureQuad(x1,y1,0.0,r1,g1,b1,u1,v1, x2,y2,0.0,r2,g2,b2,u2,v2, x3,y3,0.0,r3,g3,b3,u3,v3, x4,y4,0.0,r4,g4,b4,u4,v4, textureNumber);
	}
	void DrawTextureQuad(Double x1, Double y1, Double u1, Double v1,
                         Double x2, Double y2, Double u2, Double v2,
                         Double x3, Double y3, Double u3, Double v3,
                         Double x4, Double y4, Double u4, Double v4, int textureNumber=0){//16,17
		this->DrawTextureQuad(x1,y1,255,255,255,u1,v1, x2,y2,255,255,255,u2,v2, x3,y3,255,255,255,u3,v3, x4,y4,255,255,255,u4,v4, textureNumber);
	}

	void DrawLines(ogVFxyzc vertex[], int n){ ogDrawLines(vertex, n); }
	void DrawLineStrip(ogVFxyzc vertex[], int n){ ogDrawLineStrip(vertex, n); }
	void DrawLineStrip(ogVector *v, int n, unsigned char red, unsigned char green, unsigned char blue){
		ogVFxyzc *v2 = new ogVFxyzc[n];
		for(int i=0; i<n; i++){
			v2[i].set(v[i]);
			v2[i].setColor(red,green,blue);
		}
		ogDrawLineStrip(v2, n);
		delete v2;
	}
	void DrawLineStrip(ogVectorf *v, int n, unsigned char red, unsigned char green, unsigned char blue){
		ogVFxyzc *v2 = new ogVFxyzc[n];
		for(int i=0; i<n; i++){
			v2[i].set(v[i]);
			v2[i].setColor(red,green,blue);
		}
		ogDrawLineStrip(v2, n);
		delete v2;
	}
	void DrawLine(Double x1, Double y1, Double z1, unsigned char r1, unsigned char g1, unsigned char b1,
		          Double x2, Double y2, Double z2, unsigned char r2, unsigned char g2, unsigned char b2){ ogDrawLine(x1,y1,z1,r1,g1,b1,x2,y2,z2,r2,g2,b2); }
	void DrawLine(ogVector &v1, unsigned char r1, unsigned char g1, unsigned char b1,
		          ogVector &v2, unsigned char r2, unsigned char g2, unsigned char b2){ ogDrawLine(v1.x,v1.y,v1.z,r1,g1,b1,v2.x,v2.y,v2.z,r2,g2,b2); }
	void DrawLine(Double x1, Double y1, Double z1, Double x2, Double y2, Double z2, unsigned char red, unsigned char green, unsigned char blue){
		ogDrawLine(x1, y1, z1, red, green, blue, x2, y2, z2, red, green, blue);
	}
	void DrawLine(ogVector &v1, ogVector &v2, unsigned char red, unsigned char green, unsigned char blue){ this->DrawLine(v1.x,v1.y,v1.z,v2.x,v2.y,v2.z,red,green,blue); }
	void DrawLine(Double x1, Double y1, unsigned char r1, unsigned char g1, unsigned char b1,
		          Double x2, Double y2, unsigned char r2, unsigned char g2, unsigned char b2){ ogDrawLine(x1,y1,0.0,r1,g1,b1,x2,y2,0.0,r2,g2,b2); }
	void DrawLine(Double x1, Double y1, Double x2, Double y2, unsigned char red, unsigned char green, unsigned char blue){
		ogDrawLine(x1, y1, 0.0, red, green, blue, x2, y2, 0.0, red, green, blue);
	}
	void DrawRectangle(float x, float y, float w, float h, unsigned char red, unsigned char green, unsigned char blue){ ogDrawRectangle(x,y,w,h,red,green,blue); }
	void DrawCircle(float x, float y, float r, unsigned char red, unsigned char green, unsigned char blue, int n=16){ ogDrawCircle(x,y,r,red,green,blue,n); }
	void DrawEllipse(float x, float y, float a, float b, unsigned char red, unsigned char green, unsigned char blue, int n=16){ ogDrawEllipse(x,y,a,b,red,green,blue,n); }

	void DrawCylinder(float x1, float y1, float z1, float x2, float y2, float z2, float r, unsigned char red, unsigned char green, unsigned char blue, int n=16){
		ogDrawCylinder(x1, y1, z1, x2, y2, z2, r, red, green, blue, n); }
	void DrawCylinder(ogVector v1, ogVector v2, float r, unsigned char red, unsigned char green, unsigned char blue, int n=16){
		ogDrawCylinder(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, r, red, green, blue, n); }
	void DrawSphere(float x, float y, float z, float r, unsigned char red, unsigned char green, unsigned char blue, int level=1){
		ogDrawSphere(x, y, z, r, red, green, blue, level);
	}
	void DrawSphere(ogVector &v, float r, unsigned char red, unsigned char green, unsigned char blue, int level=1){
		ogDrawSphere(v.x, v.y, v.z, r, red, green, blue, level);
	}
	void SetKeyState(char c, bool b){
		keyState[c-'a'+ OGK_A] = b;
	}
	void SetKeyState(int key, bool b){
		keyState[key] = b;
	}
	bool KeyPressed( char key ){
	#ifdef __GLUT_H__
		return keyState[key];
	#else
		#ifdef _SDL_H
		Uint8 *keystate = SDL_GetKeyState(NULL);
		return keystate[key] !=0 ? true : false;
		#else
		if(key >='a' && key <='z' ) key += 'A'-'a';
		return (GetKeyState(key) & 0x8000) != NULL;
		#endif
	#endif
	}
	bool KeyPressed( int key ){
	#ifdef __GLUT_H__
		return keyState[key];
	#else
		#ifdef _SDL_H
		Uint8 *keystate = SDL_GetKeyState(NULL);
		return keystate[key] !=0 ? true : false;
		#else
		if(key>255) return keyState[key];
		else return (GetKeyState(key) & 0x8000) != NULL;
		#endif
	#endif
	}

	void LoadTexture(char *filename, int textureMax=256){
	#ifdef __GL_H__
		if(textureCount==0){
			texture = new GLuint[textureMax];
			glGenTextures( textureMax, texture );
		}
		ogImage image( filename );
		image.textureScale();
		glBindTexture( GL_TEXTURE_2D, texture[textureCount] );
		glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );
		glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
		glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
		glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL );
		glTexImage2D( GL_TEXTURE_2D, 0, GL_RGB, image.width, image.height,
			0, GL_RGB, GL_UNSIGNED_BYTE, image.array );
	#else
		if(textureCount==0){
			pTexture = new LPDIRECT3DTEXTURE9[textureMax];
			for(int i=0; i<textureMax; i++) pTexture[i] = NULL;
		}
		D3DXCreateTextureFromFile( g_pApp->getDevice(), filename, &pTexture[textureCount] );
	#endif
		textureCount++;
	}
	void SetTexture(int textureNumber=0){
	#ifdef __GL_H__
		glBindTexture( GL_TEXTURE_2D, texture[textureNumber] );
	#else
		 g_pApp->getDevice()->SetTexture( 0, pTexture[textureNumber] );
	#endif
		currentTexture=textureNumber;
	}
	void DeleteTexture(){
		#ifdef __GL_H__
		#else
			for(int i=0; i<textureCount; i++) SAFE_RELEASE( pTexture[i] );
		#endif
	}

};

void ogRender::RotateEyePositionUp( Double angle ){
	ogVector viewLine = center - eye;
	ogVector axis = up & viewLine;
	viewLine.rotate( axis, angle );
	up.rotate( axis, angle );
	eye = center - viewLine;
	ogLookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z);
}

void ogRender::SlideEyePositionRight( Double delta ){
	ogVector viewLine = center - eye;
	ogVector rightDirection = viewLine & up;

	rightDirection *= delta/rightDirection.abs();
	eye += rightDirection;
	center += rightDirection;
	ogLookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z);
}

int ogRender::KeyControlEyePosition( Double angle, Double delta ){
	int changed = 0;
	if( this->KeyPressed(OGK_LEFT)    ) { this->TwistEyeLeft( angle );   changed = 1; }
	if( this->KeyPressed(OGK_RIGHT)   ) { this->TwistEyeRight( angle );  changed = 1; }
	if( this->KeyPressed(OGK_UP)      ) { this->ZoomDown( delta ); changed = 1; }
	if( this->KeyPressed(OGK_DOWN)    ) { this->ZoomUp( delta );   changed = 1; }
	if( this->KeyPressed(OGK_KEYPAD4) ) { this->RotateEyePositionLeft( angle );  changed = 1; }
	if( this->KeyPressed(OGK_KEYPAD6) ) { this->RotateEyePositionRight( angle ); changed = 1; }
	if( this->KeyPressed(OGK_KEYPAD8) ) { this->RotateEyePositionUp( angle );    changed = 1; }
	if( this->KeyPressed(OGK_KEYPAD2) ) { this->RotateEyePositionDown( angle );  changed = 1; }
	if( this->KeyPressed(OGK_KEYPAD1) ) { this->SlideEyePositionLeft( delta ); changed = 1; }
	if( this->KeyPressed(OGK_KEYPAD3) ) { this->SlideEyePositionRight( delta ); changed = 1; }
	if( this->KeyPressed(OGK_KEYPAD5) ) { this->ResetEyePosition(); changed = 1; }
	return changed;
}


#ifndef og
ogRender og;
#endif

#endif //_OGRENDER_H
