#ifndef _OGTIME_H
#define _OGTIME_H

// Copyright (c) OpenMedia Lab., 2003. ver.3/16/2004

#ifdef __gl_h__
#ifndef __GL_H__
#define __GL_H__
#endif
#endif

#ifdef __gl_h_ // for Mesa GL
#ifndef __GL_H__
#define __GL_H__
#endif
#endif

#include <sys/timeb.h>
#ifdef _WIN32
	#include <time.h>
	double ftime(){
		struct timeb tm;
		ftime(&tm);
		return( double(tm.time*1000+tm.millitm)/1000.0 );
	}
#else
	#include <sys/time.h>
	double ftime(){
		struct timeval tv;
		struct timezone tz;
		gettimeofday(&tv, &tz);
		return double(tv.tv_sec) + double(tv.tv_usec)*0.000001;
 
//		for SGI
//		clock_t time = clock();
//		return ((double)time/(double)CLOCKS_PER_SEC);
	}
#endif

double ogGetFrameInterval(){
#ifdef __GL_H__
	static double previousTime = ftime();
	double currentTime = ftime();
	double frameInterval = currentTime - previousTime;
	previousTime = currentTime;
	return frameInterval;
#else
	return g_pApp->getElapsedTime();
#endif
}

class ogTimeAdjuster{
public:
	ogTimeAdjuster(double targetFI, double maxDT){ this->targetFI = targetFI; this->maxDT = maxDT; initializedFI = false; n=1; DT=realDT=realRT=0.0; dtCount=rtCount=0; }
	double targetFI;
	double realFI;
	double pastTime;
	bool   initializedFI;
	double maxDT;
	double DT; // time for simulation
	int    n;
	double realDT;
	int    dtCount;
	double realRT; // time for rendering
	int    rtCount;

	void updateFI(){
		if(!initializedFI){ pastTime = ftime(); initializedFI = true; }
		double currentTime = ftime();
		realFI = currentTime-pastTime;
		pastTime = currentTime;
		//printf("pastTime %f currentTime %f realFI %f\n",pastTime, currentTime, realFI);
	}
	void updateDT(double past){
		if(dtCount<10000){
			realDT = (realDT*dtCount+ftime()-past)/(dtCount+n);
			dtCount += n;
		}
		n = int((targetFI-realRT)/realDT);
		if( n < 1 ) n=1;
		DT = targetFI/n;
		if(DT>maxDT) DT = maxDT;
	}
	void updateRT(double past){
		if(rtCount<10000){
			realRT = (realRT*rtCount+ftime()-past)/(rtCount+1);
			rtCount++;
		}
	}
	void print(){ printf("DT %f real %f max %f n %d draw %f FI %f RTrate %d\n", DT, realDT, maxDT, n, realRT, realFI, int(DT*n/realFI*100) ); }

};

#endif //_OGTIME_H
