class CGradationBody2: public CVoxelBodyF2{// accelerated version
//class CGradationBody2: public CVoxelBody2{// original version
public:
	int levelSize;
	int *xSizes;
	int *ySizes;
	int *elementMarks;

	int sn(int level, int x, int y){ return elementMarks[level] + x+xSizes[level]*y; }
	int sn33( int i, int j ){ return i+j*3; }	
	// for construction
	CGradationBody2(){ }
	CGradationBody2( CVoxel2 &voxel, Double centerX, Double centerY, Double angle, Double scale = 1.0 ){ this->construct( voxel, centerX, centerY, angle, scale ); }
	void construct( CVoxel2 &voxel, Double centerX, Double centerY, Double angle, Double scale = 1.0 );
	void constructSizes( int xSize, int ySize );
	int registerElement( CVoxel2 &voxel, Double centerX, Double centerY, Double angle, Double scale );
	void registerJoint( CElement2 *element, int x, int y, int n );
	void registerJoint();
};

class CGradationBody: public CVoxelBodyF{// accelerated version
//class CGradationBody: public CVoxelBody{// original version
public:
	int levelSize;
	int *xSizes;
	int *ySizes;
	int *zSizes;
	int *elementMarks;

	int sn(int level, int x, int y, int z){ return elementMarks[level] + x + xSizes[level]*(y+ySizes[level]*z); }
	int sn333( int i, int j, int k ){ return i+(j+k*3)*3; }	
	// for construction
	CGradationBody(){ }
	CGradationBody( CVoxel &voxel, Double centerX, Double centerY, Double centerZ, Double angle, Double scale = 1.0 ){ this->construct( voxel, centerX, centerY, centerZ, angle, scale ); }
	void construct( CVoxel &voxel, Double centerX, Double centerY, Double centerZ, Double angle, Double scale = 1.0 );
	void constructSizes( int xSize, int ySize, int zSize );
	int registerElement( CVoxel &voxel, Double centerX, Double centerY, Double centerZ, Double angle, Double scale );
	void registerJoint( CElement *element, int x, int y, int z, int n );
	void registerJoint();
};

void CGradationBody2::construct( CVoxel2 &voxel, Double centerX, Double centerY, Double angle, Double scale ){
	this->constructSizes( voxel.xSize, voxel.ySize );
//	levelSize = 3;//for test
	this->constructElement( elementMarks[levelSize] );

	printf( "elementCount = %d\n", this->registerElement( voxel, centerX, centerY, angle, scale ) );

	this->constructJoint();
	this->registerJoint();
}
void CGradationBody::construct( CVoxel &voxel, Double centerX, Double centerY, Double centerZ, Double angle, Double scale ){
	this->constructSizes( voxel.xSize, voxel.ySize, voxel.zSize );
//	levelSize = 3;//for test
	this->constructElement( elementMarks[levelSize] );

	printf( "elementCount = %d\n", this->registerElement( voxel, centerX, centerY, centerZ, angle, scale ) );

	this->constructJoint();
	this->registerJoint();
}

void CGradationBody2::constructSizes( int xSize, int ySize ){
	this->xSize = xSize;
	this->ySize = ySize;
	levelSize = 1;
	int longestSize = xSize > ySize ? xSize : ySize;
	while( (longestSize /= 2) >= 1 ){
		levelSize++;
	}
	printf("levelSize %d\n",levelSize);

	xSizes = new int[levelSize];
	ySizes = new int[levelSize];
	elementMarks = new int[levelSize+1];
	elementMarks[0] = 0;
	xSizes[0]=xSize;
	ySizes[0]=ySize;

	int level;
	for( level=1; level<=levelSize; level++ ){
		elementMarks[level] = elementMarks[level-1] + xSizes[level-1]*ySizes[level-1];
		if(level == levelSize) break;
		xSizes[level]=(xSizes[level-1]+1)/2;
		ySizes[level]=(ySizes[level-1]+1)/2;
		printf("xSizes[%d] ySizes[%d] = %d %d\n", level, level, xSizes[level], ySizes[level]);
		printf("elementMarks[%d] = %d\n", level, elementMarks[level]);
	}
}
void CGradationBody::constructSizes( int xSize, int ySize, int zSize ){
	this->xSize = xSize;
	this->ySize = ySize;
	this->zSize = zSize;
	levelSize = 1;
	int longestSize = xSize > ySize ? (xSize > zSize ? xSize: zSize) : (ySize > zSize ? ySize: zSize);
	while( (longestSize /= 2) >= 1 ){
		levelSize++;
	}
	printf("levelSize %d\n",levelSize);

	xSizes = new int[levelSize];
	ySizes = new int[levelSize];
	zSizes = new int[levelSize];
	elementMarks = new int[levelSize+1];
	elementMarks[0] = 0;
	xSizes[0]=xSize;
	ySizes[0]=ySize;
	zSizes[0]=zSize;

	int level;
	for( level=1; level<=levelSize; level++ ){
		elementMarks[level] = elementMarks[level-1] + xSizes[level-1]*ySizes[level-1]*zSizes[level-1];
		if(level == levelSize) break;
		xSizes[level]=(xSizes[level-1]+1)/2;
		ySizes[level]=(ySizes[level-1]+1)/2;
		zSizes[level]=(zSizes[level-1]+1)/2;
		printf("xSizes[%d] ySizes[%d] zSizes[%d] = %d %d %d\n", level, level, level, xSizes[level], ySizes[level], zSizes[level]);
		printf("elementMarks[%d] = %d\n", level, elementMarks[level]);
	}
}

int CGradationBody2::registerElement( CVoxel2 &voxel, Double centerX, Double centerY, Double angle, Double scale ){
	CVoxel2 voxel2( voxel );
	int elementCount = 0;
	for( int level=1; level<levelSize; level++ ){
		int n = 1;
		for( int i=0; i<level; i++ ) n *= 2;
		int u = n/2;

		int y;
		for( y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( voxel2.ifSurface2X2( x*2, y*2 ) ){
				element[sn(level,x,y)] = new CElement2( x*2, y*2, centerX, centerY, angle, scale*u, voxel2 );
				elementCount++;
			}
		}}
		voxel2.print();
		for( y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( element[sn(level,x,y)] ) voxel2.set2X2( x*2, y*2, 0 );
		}}
		voxel2.print();
		voxel2.nextLevel();
	}
	return elementCount;
}
int CGradationBody::registerElement( CVoxel &voxel, Double centerX, Double centerY, Double centerZ, Double angle, Double scale ){
	CVoxel voxel2( voxel );
	int elementCount = 0;
	for( int level=1; level<levelSize; level++ ){
		int n = 1;
		for( int i=0; i<level; i++ ) n *= 2;
		int u = n/2;

		int z;
		for( z=0; z<zSizes[level]; z++ ){
		for( int y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( voxel2.ifSurface2X2X2( x*2, y*2, z*2 ) ){
				element[sn(level,x,y,z)] = new CElement( x*2, y*2, z*2, centerX, centerY, centerZ, angle, scale*u, voxel2 );
				//element[sn(level,x,y,z)]->print();
				elementCount++;
			}
		}}}
		voxel2.print();
		for( z=0; z<zSizes[level]; z++ ){
		for( int y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( element[sn(level,x,y,z)] ) voxel2.set2X2X2( x*2, y*2, z*2, 0 );
		}}}
		voxel2.print();
		voxel2.nextLevel();
	}
	return elementCount;
}

void CGradationBody2::registerJoint( CElement2 *element, int x, int y, int n ){
	int xo=x*n;
	int yo=y*n;
	int u = n/2;
	for( int j=0; j<2; j++ ){
	for( int i=0; i<2; i++ ){
		int i2 = i*2;
		int j2 = j*2;
		if( element->vertex[sn33(i2,j2)] ){
			CVoxelBody2::registerJoint( element->vertex[sn33(i2,j2)], xo+u*i2, yo+u*j2, 3-sn22(i,j) );
			if(element->vertex[sn33(1,j2)] ) CVoxelBody2::registerJoint( element->vertex[sn33(1,j2)], xo+u, yo+u*j2, sn22(i,1-j) );
			if(element->vertex[sn33(i2,1)] ) CVoxelBody2::registerJoint( element->vertex[sn33(i2,1)], xo+u*i2, yo+u, sn22(1-i,j) );
			if( element->vertex[4] ) CVoxelBody2::registerJoint( element->vertex[4], xo+u, yo+u, sn22(i,j) );
		}
	}}
}
void CGradationBody::registerJoint( CElement *element, int x, int y, int z, int n ){
	int xo=x*n;
	int yo=y*n;
	int zo=z*n;
	int u = n/2;
	for( int k=0; k<2; k++ ){
	for( int j=0; j<2; j++ ){
	for( int i=0; i<2; i++ ){
		int i2 = i*2;
		int j2 = j*2;
		int k2 = k*2;
		if( element->vertex[sn333(i2,j2,k2)] ){
			CVoxelBody::registerJoint( element->vertex[sn333(i2,j2,k2)], xo+u*i2, yo+u*j2, zo+u*k2, 7-sn222(i,j,k) );
			if(element->vertex[sn333(1,j2,k2)] ) CVoxelBody::registerJoint( element->vertex[sn333(1,j2,k2)], xo+u, yo+u*j2, zo+u*k2, sn222(i,1-j,1-k) );
			if(element->vertex[sn333(i2,1,k2)] ) CVoxelBody::registerJoint( element->vertex[sn333(i2,1,k2)], xo+u*i2, yo+u, zo+u*k2, sn222(1-i,j,1-k) );
			if(element->vertex[sn333(i2,j2,1)] ) CVoxelBody::registerJoint( element->vertex[sn333(i2,j2,1)], xo+u*i2, yo+u*j2, zo+u, sn222(1-i,1-j,k) );
			if(element->vertex[sn333(i2,1,1)] ) CVoxelBody::registerJoint( element->vertex[sn333(i2,1,1)], xo+u*i2, yo+u, zo+u, sn222(1-i,j,k) );
			if(element->vertex[sn333(1,j2,1)] ) CVoxelBody::registerJoint( element->vertex[sn333(1,j2,1)], xo+u, yo+u*j2, zo+u, sn222(i,1-j,k) );
			if(element->vertex[sn333(1,1,k2)] ) CVoxelBody::registerJoint( element->vertex[sn333(1,1,k2)], xo+u, yo+u, zo+u*k2, sn222(i,j,1-k) );
			if( element->vertex[13] ) CVoxelBody::registerJoint( element->vertex[13], xo+u, yo+u, zo+u, sn222(i,j,k) );
		}
	}}}
}

void CGradationBody2::registerJoint(){
	for( int level=1; level<levelSize; level++ ){
		int n = 1;
		for( int i=0; i<level; i++ ) n *= 2;

		for( int y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( element[sn(level,x,y)] ) this->registerJoint( element[sn(level,x,y)], x, y, n );
		}}
	}
}
void CGradationBody::registerJoint(){
	for( int level=1; level<levelSize; level++ ){
		int n = 1;
		for( int i=0; i<level; i++ ) n *= 2;

		for( int z=0; z<zSizes[level]; z++ ){
		for( int y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( element[sn(level,x,y,z)] ) this->registerJoint( element[sn(level,x,y,z)], x, y, z, n );
		}}}
	}
}
