class CVoxel2{
public:
	int xSize;
	int ySize;
	int *array;

	void construct(){ if( array != NULL ) delete array; array = new int[xSize*ySize]; }
	void construct( int xSize, int ySize ){ this->xSize=xSize; this->ySize=ySize; this->construct(); }
	void fillSquare( int x, int y );
	void fillRound( int x, int y );
	void fill( char *index, int x, int y ){ index[0] == 's' || index[0] == 'S' ? this->fillSquare( x, y ) : this->fillRound( x, y ); }
	void construct( char *index, int xSize, int ySize, int xFill, int yFill ){ this->construct( xSize, ySize ); this->fill( index, xFill, yFill ); }
	CVoxel2(){ array = NULL; }
	CVoxel2( CVoxel2 &voxel ){ array = NULL; this->copy( voxel ); }
	CVoxel2( char *index, int xSize, int ySize ){ array = NULL; int x=1, y=1; while(x<xSize) x*=2; while(y<ySize) y*=2; this->construct( index, x, y, xSize, ySize); }
	CVoxel2( char *index, int size ){ array = NULL; int s=1; while(s<size) s*=2; this->construct( index, s, s, size, size ); }
	~CVoxel2(){ if( array!= NULL ) delete array; }

	void set0( int x, int y ){ array[x+xSize*y] = 0; }
	void set1( int x, int y ){ array[x+xSize*y] = 1; }
	void set( int x, int y, int value ){ array[x+xSize*y] = value; }
	void set( int value ){ for( int i=0; i<xSize*ySize; i++ ) array[i] = value; }
	void set2X2( int x, int y, int value ){ for( int j=0; j<2; j++ ) for( int i=0; i<2; i++ ) this->set( x+i, y+j, value ); }
	int count( int value ){ int n = 0; for( int i=0; i<xSize*ySize; i++ ) if( array[i] == value ) n++; return n; }
	void copy( CVoxel2 &voxel ){ this->construct( voxel.xSize, voxel.ySize ); for( int i=0; i<xSize*ySize; i++ ) array[i] = voxel.array[i]; }
	CVoxel2 operator =( CVoxel2 &voxel ){ this->copy( voxel ); return *this; }
	int density( int x, int y ){ if( x<0 || x>=xSize || y<0 || y>=ySize ) return 0; return array[x+xSize*y]; }
	void print();

	int ifSurface( int x, int y, char direction );
	int ifSurface( int x, int y );
	int ifAllZero2X2( int x, int y );
	int ifSurface2X2( int x, int y );
	void nextLevel( CVoxel2 &original );
	void nextLevel(){ CVoxel2 tmp; tmp.nextLevel( *this ); this->copy( tmp ); }
	int neighbors( int x, int y ){ int count = 0; for( int i=0; i<4; i++ ) if( this->density( x-(i%3+1)/2, y-i/2 ) ) count++; return count; }
	int jointSize();
	int ifSmoothSurface( int x, int y, int nx, int ny );
	int smoothSurfaceSize();
};

class CVoxel{
public:
	int xSize;
	int ySize;
	int zSize;
	int *array;

	void construct(){ if( array != NULL ) delete array; array = new int[xSize*ySize*zSize]; }
	void construct( int xSize, int ySize, int zSize ){ this->xSize=xSize; this->ySize=ySize; this->zSize=zSize; this->construct(); }
	void fillSquare( int x, int y, int z );
	void fillRound( int x, int y, int z );
	void fill( char *index, int x, int y, int z ){ index[0] == 's' || index[0] == 'S' ? this->fillRound( x, y, z ) : this->fillSquare( x, y, z ); }
	void construct( char *index, int xSize, int ySize, int zSize, int xFill, int yFill, int zFill ){ this->construct( xSize, ySize, zSize ); this->fill( index, xFill, yFill, zFill ); }
	CVoxel(){ array = NULL; }
	CVoxel( CVoxel &voxel ){ array = NULL; this->copy( voxel ); }
	CVoxel( char *index, int xSize, int ySize, int zSize ){ array = NULL; int x=1, y=1, z=1; while(x<xSize) x*=2; while(y<ySize) y*=2; while(z<zSize) z*=2; this->construct( index, x, y, z, xSize, ySize, zSize ); }
	CVoxel( char *index, int size ){ array = NULL; int s=1; while(s<size) s*=2; this->construct( index, s, s, s, size, size, size ); }
	~CVoxel(){ if( array!= NULL ) delete array; }

	void set0( int x, int y, int z ){ array[x+xSize*(y+z*ySize)] = 0; }
	void set1( int x, int y, int z ){ array[x+xSize*(y+z*ySize)] = 1; }
	void set( int x, int y, int z, int value ){ array[x+xSize*(y+z*ySize)] = value; }
	void set( int value ){ for( int i=0; i<xSize*ySize*zSize; i++ ) array[i] = value; }
	void set2X2X2( int x, int y, int z, int value ){ for( int k=0; k<2; k++ ) for( int j=0; j<2; j++ ) for( int i=0; i<2; i++ ) this->set( x+i, y+j, z+k, value ); }
	int count( int value ){ int n = 0; for( int i=0; i<xSize*ySize*zSize; i++ ) if( array[i] == value ) n++; return n; }
	void copy( CVoxel &voxel ){ this->construct( voxel.xSize, voxel.ySize, voxel.zSize ); for( int i=0; i<xSize*ySize*zSize; i++ ) array[i] = voxel.array[i]; }
	CVoxel operator =( CVoxel &voxel ){ this->copy( voxel ); return *this; }
	int density( int x, int y, int z ){ if( x<0 || x>=xSize || y<0 || y>=ySize || z<0 || z>=zSize ) return 0; return array[x+xSize*(y+z*ySize)]; }
	void print();

	int ifSurface( int x, int y, int z, char direction );
	int ifSurface( int x, int y, int z );
	int ifAllZero2X2X2( int x, int y, int z );
	int ifSurface2X2X2( int x, int y, int z );
	void nextLevel( CVoxel &original );
	void nextLevel(){ CVoxel tmp; tmp.nextLevel( *this ); this->copy( tmp ); }
	int neighbors( int x, int y, int z ){ int count = 0; for( int i=0; i<8; i++ ) if( this->density(  x-(i%4%3+1)/2, y-i%4/2, z-i/4  ) ) count++; return count; }
	int jointSize();
	int ifSmoothSurface( int x, int y, int z, char direction );
	int ifSmoothSurface0( int x, int y, int z, char directionX, char directionY, char directionZ );
	int ifSmoothSurface1( int x, int y, int z, char directionX, char directionY, char directionZ, char direction );
	int ifSmoothSurface2( int x, int y, int z, char baseAxis, char direction1, char direction2 );
	int ifSmoothSurfaces2X( int x, int y, int z, char direction1, char direction2 ){ return this->ifSmoothSurface2( x, y, z, 'x', direction1, direction2 ) && this->ifSmoothSurface2( x, y, z, 'X', direction1, direction2 ); }
	int ifSmoothSurfaces2Y( int x, int y, int z, char direction1, char direction2 ){ return this->ifSmoothSurface2( x, y, z, 'y', direction1, direction2 ) && this->ifSmoothSurface2( x, y, z, 'Y', direction1, direction2 ); }
	int ifSmoothSurfaces2Z( int x, int y, int z, char direction1, char direction2 ){ return this->ifSmoothSurface2( x, y, z, 'z', direction1, direction2 ) && this->ifSmoothSurface2( x, y, z, 'Z', direction1, direction2 ); }
	int ifSmoothSurface3( int x, int y, int z, char directionX, char directionY, char directionZ );
	int smoothSurfaceSize();
};


void CVoxel2::fillSquare( int x, int y ){
	for( int j=0; j<ySize; j++ ){
	for( int i=0; i<xSize; i++ ){
		if( i >= xSize/2-x/2 && i < xSize/2-x/2+x && j >= ySize/2-y/2 && j < ySize/2-y/2+y ) this->set1( i, j );
		else this->set0( i, j );
	}}
}
void CVoxel::fillSquare( int x, int y, int z ){
	for( int k=0; k<zSize; k++ ){
	for( int j=0; j<ySize; j++ ){
	for( int i=0; i<xSize; i++ ){
			if( i >= xSize/2-x/2 && i < xSize/2-x/2+x && j >= ySize/2-y/2 && j < ySize/2-y/2+y && k >= zSize/2-z/2 && k < zSize/2-z/2+z ) this->set1( i, j, k );
			else this->set0( i, j, k );
	}}}
}

void CVoxel2::fillRound( int x, int y ){
	ogVector2 center( (xSize-1)/2.0, (ySize-1)/2.0 );
	for( int j=0; j<ySize; j++ ){
	for( int i=0; i<xSize; i++ ){
		if( (i-center.x)*(i-center.x)/(x*x/4.0)+(j-center.y)*(j-center.y)/(y*y/4.0) <= 1.0 ) this->set1( i, j );
		else this->set0( i, j );
	}}
}
void CVoxel::fillRound( int x, int y, int z ){
	ogVector center( (xSize-1)/2.0, (ySize-1)/2.0, (zSize-1)/2.0 );
	for( int k=0; k<zSize; k++ ){
	for( int j=0; j<ySize; j++ ){
	for( int i=0; i<xSize; i++ ){
		if( (i-center.x)*(i-center.x)/(x*x/4.0)+(j-center.y)*(j-center.y)/(y*y/4.0)+(k-center.z)*(k-center.z)/(z*z/4.0) <= 1.0 ) this->set1( i, j, k );
		else this->set0( i, j, k );
	}}}
}

int CVoxel2::ifSurface( int x, int y, char direction ){
	if( !this->density( x, y ) ) return 0;
	switch( direction ){
		case 'x': return !this->density( x-1, y );
		case 'X': return !this->density( x+1, y );
		case 'y': return !this->density( x, y-1 );
		case 'Y': return !this->density( x, y+1 );
	}
	return 0;
}
int CVoxel::ifSurface( int x, int y, int z, char direction ){
	if( !this->density( x, y, z ) ) return 0;
	switch( direction ){
		case 'x': return !this->density( x-1, y, z );
		case 'X': return !this->density( x+1, y, z );
		case 'y': return !this->density( x, y-1, z );
		case 'Y': return !this->density( x, y+1, z );
		case 'z': return !this->density( x, y, z-1 );
		case 'Z': return !this->density( x, y, z+1 );
	}
	return 0;
}

int CVoxel2::ifSurface( int x, int y ){
	if( !this->density( x, y ) ) return 0;
	if( !this->density( x-1, y ) ) return 1;
	if( !this->density( x+1, y ) ) return 1;
	if( !this->density( x, y-1 ) ) return 1;
	if( !this->density( x, y+1 ) ) return 1;
	return 0;
}
int CVoxel::ifSurface( int x, int y, int z ){
	if( !this->density( x, y, z ) ) return 0;
	if( !this->density( x-1, y, z ) ) return 1;
	if( !this->density( x+1, y, z ) ) return 1;
	if( !this->density( x, y-1, z ) ) return 1;
	if( !this->density( x, y+1, z ) ) return 1;
	if( !this->density( x, y, z-1 ) ) return 1;
	if( !this->density( x, y, z+1 ) ) return 1;
	return 0;
}

int CVoxel2::ifAllZero2X2( int x, int y ){ // 4 voxels make a voxel unit in the next level.
	for( int i=0; i<4; i++ ){
		if( this->density( x+(i%3+1)/2, y+i/2 ) ) return 0;
	}
	return 1;
}
int CVoxel::ifAllZero2X2X2( int x, int y, int z ){
	for( int i=0; i<8; i++ ){
		if( this->density( x+(i%4%3+1)/2, y+i%4/2, z+i/4 ) ) return 0;
	}
	return 1;
}

int CVoxel2::ifSurface2X2( int x, int y ){
	if( this->ifAllZero2X2( x, y ) ) return 0;
	for( int i=0; i<4; i++ ){
		if( this->density( x+(i%3+1)/2, y+i/2 ) == 0 ){
			return 1;
		}
	}
	for( int j=0; j<4; j++ ){
		if( this->ifSurface( x+(j%3+1)/2, y+j/2 ) ){
			return 1;
		}
	}
	return 0;
}
int CVoxel::ifSurface2X2X2( int x, int y, int z ){
	if( this->ifAllZero2X2X2( x, y, z ) ) return 0;
	for( int i=0; i<8; i++ ){
		if( this->density( x+(i%4%3+1)/2, y+i%4/2, z+i/4 ) == 0 ){
			return 1;
		}
	}
	for( int j=0; j<8; j++ ){
		if( this->ifSurface( x+(j%4%3+1)/2, y+j%4/2, z+j/4 ) ){
			return 1;
		}
	}
	return 0;
}

void CVoxel2::nextLevel( CVoxel2 &original ){
	xSize = original.xSize/2;
	ySize = original.ySize/2;
	this->construct();
	for( int y=0; y<ySize; y++ ){
	for( int x=0; x<xSize; x++ ){
		if( original.ifAllZero2X2( x*2, y*2 ) ) this->set0( x, y );
		else this->set1( x, y );
	}}
}
void CVoxel::nextLevel( CVoxel &original ){
	xSize = original.xSize/2; if( xSize%2 == 1 ) xSize--;
	ySize = original.ySize/2; if( ySize%2 == 1 ) ySize--;
	zSize = original.zSize/2; if( zSize%2 == 1 ) zSize--;
	this->construct();
	for( int z=0; z<zSize; z++ ){
	for( int y=0; y<ySize; y++ ){
	for( int x=0; x<xSize; x++ ){
		if( original.ifAllZero2X2X2( x*2, y*2, z*2 ) || original.ifSurface2X2X2( x*2, y*2, z*2 ) ) this->set0( x, y, z );
		else this->set1( x, y, z );
	}}}
}

int CVoxel2::jointSize(){
	int count = 0;
	for( int y=0; y<=ySize; y++ ){
	for( int x=0; x<=xSize; x++ ){
		if( neighbors( x, y ) > 1 ) count++;
	}}
	return count;
}
int CVoxel::jointSize(){
	int count = 0;
	for( int z=0; z<=zSize; z++ ){
	for( int y=0; y<=ySize; y++ ){
	for( int x=0; x<=xSize; x++ ){
		if( neighbors( x, y, z ) > 1 ) count++;
	}}}
	return count;
}

int CVoxel2::ifSmoothSurface( int x, int y, int nx, int ny ){
	if( this->density( x, y ) ){
		if( nx == -1 && ny ==  0 ) return !this->density( x-1, y-1 ) && !this->density( x-1, y ) && !this->density( x-1, y+1 );
		if( nx ==  1 && ny ==  0 ) return !this->density( x+1, y-1 ) && !this->density( x+1, y ) && !this->density( x+1, y+1 );
		if( nx ==  0 && ny == -1 ) return !this->density( x-1, y-1 ) && !this->density( x, y-1 ) && !this->density( x+1, y-1 );
		if( nx ==  0 && ny ==  1 ) return !this->density( x-1, y+1 ) && !this->density( x, y+1 ) && !this->density( x+1, y+1 );
		if( nx * ny == -1 ) return 0;
		if( nx * ny ==  1 ) return 0;
	}else{
		if( nx == -1 && ny ==  0 ) return !this->density( x-1, y ) && this->density( x+1, y ) && this->density( x, y-1 ) && this->density( x, y+1 );
		if( nx ==  1 && ny ==  0 ) return this->density( x-1, y ) && !this->density( x+1, y ) && this->density( x, y-1 ) && this->density( x, y+1 );
		if( nx ==  0 && ny == -1 ) return this->density( x-1, y ) && this->density( x+1, y ) && !this->density( x, y-1 ) && this->density( x, y+1 );
		if( nx ==  0 && ny ==  1 ) return this->density( x-1, y ) && this->density( x+1, y ) && this->density( x, y-1 ) && !this->density( x, y+1 );
		if( nx * ny == -1 ) return (this->density( x-1, y )-this->density( x, y-1 ))*(this->density( x, y+1 )-this->density( x+1, y )) == 1 ? 1 : 0;
		if( nx * ny ==  1 ) return (this->density( x-1, y )-this->density( x, y+1 ))*(this->density( x, y-1 )-this->density( x+1, y )) == 1 ? 1 : 0;
	}
	return 0;
}
int CVoxel::ifSmoothSurface( int x, int y, int z, char direction ){
	if( this->density( x, y, z ) ){
		switch( direction ){
			case 'x': return !this->density( x-1, y-1, z-1 ) && !this->density( x-1, y, z-1 ) && !this->density( x-1, y+1, z-1 ) && !this->density( x-1, y-1, z ) && !this->density( x-1, y, z ) && !this->density( x-1, y+1, z ) && !this->density( x-1, y-1, z+1 ) && !this->density( x-1, y, z+1 ) && !this->density( x-1, y+1, z+1 );
			case 'X': return !this->density( x+1, y-1, z-1 ) && !this->density( x+1, y, z-1 ) && !this->density( x+1, y+1, z-1 ) && !this->density( x+1, y-1, z ) && !this->density( x+1, y, z ) && !this->density( x+1, y+1, z ) && !this->density( x+1, y-1, z+1 ) && !this->density( x+1, y, z+1 ) && !this->density( x+1, y+1, z+1 );
			case 'y': return !this->density( x-1, y-1, z-1 ) && !this->density( x, y-1, z-1 ) && !this->density( x+1, y-1, z-1 ) && !this->density( x-1, y-1, z ) && !this->density( x, y-1, z ) && !this->density( x+1, y-1, z ) && !this->density( x-1, y-1, z+1 ) && !this->density( x, y-1, z+1 ) && !this->density( x+1, y-1, z+1 );
			case 'Y': return !this->density( x-1, y+1, z-1 ) && !this->density( x, y+1, z-1 ) && !this->density( x+1, y+1, z-1 ) && !this->density( x-1, y+1, z ) && !this->density( x, y+1, z ) && !this->density( x+1, y+1, z ) && !this->density( x-1, y+1, z+1 ) && !this->density( x, y+1, z+1 ) && !this->density( x+1, y+1, z+1 );
			case 'z': return !this->density( x-1, y-1, z-1 ) && !this->density( x, y-1, z-1 ) && !this->density( x+1, y-1, z-1 ) && !this->density( x-1, y, z-1 ) && !this->density( x, y, z-1 ) && !this->density( x+1, y, z-1 ) && !this->density( x-1, y+1, z-1 ) && !this->density( x, y+1, z-1 ) && !this->density( x+1, y+1, z-1 );
			case 'Z': return !this->density( x-1, y-1, z+1 ) && !this->density( x, y-1, z+1 ) && !this->density( x+1, y-1, z+1 ) && !this->density( x-1, y, z+1 ) && !this->density( x, y, z+1 ) && !this->density( x+1, y, z+1 ) && !this->density( x-1, y+1, z+1 ) && !this->density( x, y+1, z+1 ) && !this->density( x+1, y+1, z+1 );
			default : return 0;
		}
	}else{
		switch( direction ){
			case 'x': return !this->density( x-1, y, z ) && (this->density( x, y-1, z ) && this->density( x, y+1, z ) || this->density( x, y, z-1 ) && this->density( x, y, z+1 ) );
			case 'X': return !this->density( x+1, y, z ) && (this->density( x, y-1, z ) && this->density( x, y+1, z ) || this->density( x, y, z-1 ) && this->density( x, y, z+1 ) );
			case 'y': return !this->density( x, y-1, z ) && (this->density( x, y, z-1 ) && this->density( x, y, z+1 ) || this->density( x-1, y, z ) && this->density( x+1, y, z ) );
			case 'Y': return !this->density( x, y+1, z ) && (this->density( x, y, z-1 ) && this->density( x, y, z+1 ) || this->density( x-1, y, z ) && this->density( x+1, y, z ) );
			case 'z': return !this->density( x, y, z-1 ) && (this->density( x-1, y, z ) && this->density( x+1, y, z ) || this->density( x, y-1, z ) && this->density( x, y+1, z ) );
			case 'Z': return !this->density( x, y, z+1 ) && (this->density( x-1, y, z ) && this->density( x+1, y, z ) || this->density( x, y-1, z ) && this->density( x, y+1, z ) );
			default : return 0;
		}
	}
	return 0;
}
int CVoxel::ifSmoothSurface0( int x, int y, int z, char directionX, char directionY, char directionZ ){
	if( this->density( x, y, z ) ) return 0;
	if( directionX == 'x' ){
		if( directionY == 'y' ){
			if( directionZ == 'z' ) return !this->density( x-1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y-1, z );
			else                    return !this->density( x-1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y-1, z );
		}else{
			if( directionZ == 'z' ) return !this->density( x-1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y+1, z );
			else                    return !this->density( x-1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y+1, z );
		}
	}else{
		if( directionY == 'y' ){
			if( directionZ == 'z' ) return !this->density( x+1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y-1, z );
			else                    return !this->density( x+1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y-1, z );
		}else{
			if( directionZ == 'z' ) return !this->density( x+1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y+1, z );
			else                    return !this->density( x+1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y+1, z );
		}
	}
	return 0;
}
int CVoxel::ifSmoothSurface1( int x, int y, int z, char directionX, char directionY, char directionZ, char direction ){
	if( this->density( x, y, z ) ) return 0;
	if( directionX == 'x' ){
		if( directionY == 'y' ){
			if( directionZ == 'z' ){
				switch( direction ){
				case 'x': return this->density( x-1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y-1, z );
				case 'y': return !this->density( x-1, y, z ) && this->density( x, y-1, z ) && !this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y-1, z );
				case 'z': return !this->density( x-1, y, z ) && !this->density( x, y-1, z ) && this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y-1, z );
				}
			}else{
				switch( direction ){
				case 'x': return this->density( x-1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y-1, z );
				case 'y': return !this->density( x-1, y, z ) && this->density( x, y-1, z ) && !this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y-1, z );
				case 'z': return !this->density( x-1, y, z ) && !this->density( x, y-1, z ) && this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y-1, z );
				}
			}
		}else{
			if( directionZ == 'z' ){
				switch( direction ){
				case 'x': return this->density( x-1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y+1, z );
				case 'y': return !this->density( x-1, y, z ) && this->density( x, y+1, z ) && !this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y+1, z );
				case 'z': return !this->density( x-1, y, z ) && !this->density( x, y+1, z ) && this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x-1, y, z-1 ) && this->density( x-1, y+1, z );
				}
			}else{
				switch( direction ){
				case 'x': return this->density( x-1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y+1, z );
				case 'y': return !this->density( x-1, y, z ) && this->density( x, y+1, z ) && !this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y+1, z );
				case 'z': return !this->density( x-1, y, z ) && !this->density( x, y+1, z ) && this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x-1, y, z+1 ) && this->density( x-1, y+1, z );
				}
			}
		}
	}else{
		if( directionY == 'y' ){
			if( directionZ == 'z' ){
				switch( direction ){
				case 'x': return this->density( x+1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y-1, z );
				case 'y': return !this->density( x+1, y, z ) && this->density( x, y-1, z ) && !this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y-1, z );
				case 'z': return !this->density( x+1, y, z ) && !this->density( x, y-1, z ) && this->density( x, y, z-1 ) && this->density( x, y-1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y-1, z );
				}
			}else{
				switch( direction ){
				case 'x': return this->density( x+1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y-1, z );
				case 'y': return !this->density( x+1, y, z ) && this->density( x, y-1, z ) && !this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y-1, z );
				case 'z': return !this->density( x+1, y, z ) && !this->density( x, y-1, z ) && this->density( x, y, z+1 ) && this->density( x, y-1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y-1, z );
				}
			}
		}else{
			if( directionZ == 'z' ){
				switch( direction ){
				case 'x': return this->density( x+1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y+1, z );
				case 'y': return !this->density( x+1, y, z ) && this->density( x, y+1, z ) && !this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y+1, z );
				case 'z': return !this->density( x+1, y, z ) && !this->density( x, y+1, z ) && this->density( x, y, z-1 ) && this->density( x, y+1, z-1 ) && this->density( x+1, y, z-1 ) && this->density( x+1, y+1, z );
				}
			}else{
				switch( direction ){
				case 'x': return this->density( x+1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y+1, z );
				case 'y': return !this->density( x+1, y, z ) && this->density( x, y+1, z ) && !this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y+1, z );
				case 'z': return !this->density( x+1, y, z ) && !this->density( x, y+1, z ) && this->density( x, y, z+1 ) && this->density( x, y+1, z+1 ) && this->density( x+1, y, z+1 ) && this->density( x+1, y+1, z );
				}
			}
		}
	}
	return 0;
}
int CVoxel::ifSmoothSurface2( int x, int y, int z, char baseAxis, char direction1, char direction2 ){
	if( this->density( x, y, z ) ) return 0;
	if( baseAxis == 'x' || baseAxis == 'X' ){
		int i = baseAxis == 'x' ? -1 : 1;
		if( direction1 == 'y' && direction2 == 'z' || direction1 == 'z' && direction2 == 'y'){
			return !this->density( x+i, y, z ) && this->density( x, y-1, z ) && this->density( x, y, z-1 ) && !this->density( x, y+1, z ) && !this->density( x, y, z+1 );
		}else if( direction1 == 'Y' && direction2 == 'z' || direction1 == 'z' && direction2 == 'Y'){
			return !this->density( x+i, y, z ) && this->density( x, y+1, z ) && this->density( x, y, z-1 ) && !this->density( x, y-1, z ) && !this->density( x, y, z+1 );
		}else if( direction1 == 'y' && direction2 == 'Z' || direction1 == 'Z' && direction2 == 'y'){
			return !this->density( x+i, y, z ) && this->density( x, y-1, z ) && this->density( x, y, z+1 ) && !this->density( x, y+1, z ) && !this->density( x, y, z-1 );
		}else{ //if( direction1 == 'Y' && direction2 == 'Z' || direction1 == 'Z' && direction2 == 'Y')
			return !this->density( x+i, y, z ) && this->density( x, y+1, z ) && this->density( x, y, z+1 ) && !this->density( x, y-1, z ) && !this->density( x, y, z-1 );
		}
	}else if( baseAxis == 'y' || baseAxis == 'Y' ){
		int i = baseAxis == 'y' ? -1 : 1;
		if( direction1 == 'z' && direction2 == 'x' || direction1 == 'x' && direction2 == 'z'){
			return !this->density( x, y+i, z ) && this->density( x, y, z-1 ) && this->density( x-1, y, z ) && !this->density( x, y, z+1 ) && !this->density( x+1, y, z );
		}else if( direction1 == 'Z' && direction2 == 'x' || direction1 == 'x' && direction2 == 'Z'){
			return !this->density( x, y+i, z ) && this->density( x, y, z+1 ) && this->density( x-1, y, z ) && !this->density( x, y, z-1 ) && !this->density( x+1, y, z );
		}else if( direction1 == 'z' && direction2 == 'X' || direction1 == 'X' && direction2 == 'z'){
			return !this->density( x, y+i, z ) && this->density( x, y, z-1 ) && this->density( x+1, y, z ) && !this->density( x, y, z+1 ) && !this->density( x-1, y, z );
		}else{ //if( direction1 == 'Z' && direction2 == 'X' || direction1 == 'X' && direction2 == 'Z')
			return !this->density( x, y+i, z ) && this->density( x, y, z+1 ) && this->density( x+1, y, z ) && !this->density( x, y, z-1 ) && !this->density( x-1, y, z );
		}
	}else{ //if( baseAxis == 'z' || baseAxis == 'Z' )
		int i = baseAxis == 'z' ? -1 : 1;
		if( direction1 == 'x' && direction2 == 'y' || direction1 == 'y' && direction2 == 'x'){
			return !this->density( x, y, z+i ) && this->density( x-1, y, z ) && this->density( x, y-1, z ) && !this->density( x+1, y, z ) && !this->density( x, y+1, z );
		}else if( direction1 == 'X' && direction2 == 'y' || direction1 == 'y' && direction2 == 'X'){
			return !this->density( x, y, z+i ) && this->density( x+1, y, z ) && this->density( x, y-1, z ) && !this->density( x-1, y, z ) && !this->density( x, y+1, z );
		}else if( direction1 == 'x' && direction2 == 'Y' || direction1 == 'Y' && direction2 == 'x'){
			return !this->density( x, y, z+i ) && this->density( x-1, y, z ) && this->density( x, y+1, z ) && !this->density( x+1, y, z ) && !this->density( x, y-1, z );
		}else{ //if( direction1 == 'X' && direction2 == 'Y' || direction1 == 'Y' && direction2 == 'X')
			return !this->density( x, y, z+i ) && this->density( x+1, y, z ) && this->density( x, y+1, z ) && !this->density( x-1, y, z ) && !this->density( x, y-1, z );
		}
	}
	return 0;
}
int CVoxel::ifSmoothSurface3( int x, int y, int z, char directionX, char directionY, char directionZ ){
	if( this->density( x, y, z ) ) return 0;
	if( directionX == 'x' ){
		if( directionY == 'y' ){
			if( directionZ == 'z' ) return this->density( x-1, y, z ) && this->density( x, y-1, z ) && this->density( x, y, z-1 ) && !this->density( x+1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z+1 );
			else                    return this->density( x-1, y, z ) && this->density( x, y-1, z ) && this->density( x, y, z+1 ) && !this->density( x+1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z-1 );
		}else{
			if( directionZ == 'z' ) return this->density( x-1, y, z ) && this->density( x, y+1, z ) && this->density( x, y, z-1 ) && !this->density( x+1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z+1 );
			else                    return this->density( x-1, y, z ) && this->density( x, y+1, z ) && this->density( x, y, z+1 ) && !this->density( x+1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z-1 );
		}
	}else{
		if( directionY == 'y' ){
			if( directionZ == 'z' ) return this->density( x+1, y, z ) && this->density( x, y-1, z ) && this->density( x, y, z-1 ) && !this->density( x-1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z+1 );
			else                    return this->density( x+1, y, z ) && this->density( x, y-1, z ) && this->density( x, y, z+1 ) && !this->density( x-1, y, z ) && !this->density( x, y+1, z ) && !this->density( x, y, z-1 );
		}else{
			if( directionZ == 'z' ) return this->density( x+1, y, z ) && this->density( x, y+1, z ) && this->density( x, y, z-1 ) && !this->density( x-1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z+1 );
			else                    return this->density( x+1, y, z ) && this->density( x, y+1, z ) && this->density( x, y, z+1 ) && !this->density( x-1, y, z ) && !this->density( x, y-1, z ) && !this->density( x, y, z-1 );
		}
	}
	return 0;
}

int CVoxel2::smoothSurfaceSize(){
	int count = 0;
	for( int y=0; y<ySize; y++ ){
		for( int x=0; x<xSize; x++ ){
			if( this->ifSmoothSurface( x, y, -1, 0 ) ) count++;
			if( this->ifSmoothSurface( x, y,  1, 0 ) ) count++;
			if( this->ifSmoothSurface( x, y, 0, -1 ) ) count++;
			if( this->ifSmoothSurface( x, y,  0, 1 ) ) count++;
			if( this->ifSmoothSurface( x, y, -1, 1 ) ) count++;
			if( this->ifSmoothSurface( x, y,  1, 1 ) ) count++;
		}
	}
	return count;
}
int CVoxel::smoothSurfaceSize(){
	int count = 0;
	for( int z=0; z<zSize; z++ ){
	for( int y=0; y<ySize; y++ ){
	for( int x=0; x<xSize; x++ ){
		for( int i=0; i<2; i++ ){
			char direction = 'x' + ('A'-'a')*i;
			if( this->ifSmoothSurface( x, y, z, direction ) ) count+=2;
			if( this->ifSmoothSurface2( x, y, z, direction, 'y', 'z' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'Y', 'z' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'Y', 'Z' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'y', 'Z' ) ) count++;
			direction = 'y' + ('A'-'a')*i;
			if( this->ifSmoothSurface( x, y, z, direction ) ) count+=2;
			if( this->ifSmoothSurface2( x, y, z, direction, 'z', 'x' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'Z', 'x' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'Z', 'X' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'z', 'X' ) ) count++;
			direction = 'z' + ('A'-'a')*i;
			if( this->ifSmoothSurface( x, y, z, direction ) ) count+=2;
			if( this->ifSmoothSurface2( x, y, z, direction, 'x', 'y' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'X', 'y' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'X', 'Y' ) ) count++;
			if( this->ifSmoothSurface2( x, y, z, direction, 'x', 'Y' ) ) count++;
		}
		if( this->ifSmoothSurface0( x, y, z, 'x', 'y', 'z' ) ) count++;
		if( this->ifSmoothSurface0( x, y, z, 'x', 'Y', 'z' ) ) count++;
		if( this->ifSmoothSurface0( x, y, z, 'x', 'Y', 'Z' ) ) count++;
		if( this->ifSmoothSurface0( x, y, z, 'x', 'y', 'Z' ) ) count++;
		if( this->ifSmoothSurface0( x, y, z, 'X', 'y', 'z' ) ) count++;
		if( this->ifSmoothSurface0( x, y, z, 'X', 'Y', 'z' ) ) count++;
		if( this->ifSmoothSurface0( x, y, z, 'X', 'Y', 'Z' ) ) count++;
		if( this->ifSmoothSurface0( x, y, z, 'X', 'y', 'Z' ) ) count++;

		if( this->ifSmoothSurface1( x, y, z, 'x', 'y', 'z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'y', 'z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'y', 'z',  'z' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'Y', 'Z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'Y', 'Z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'Y', 'Z',  'z' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'y', 'z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'y', 'z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'y', 'z',  'z' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'Y', 'Z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'Y', 'Z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'Y', 'Z',  'z' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'Y', 'z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'Y', 'z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'Y', 'z',  'z' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'y', 'Z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'y', 'Z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'y', 'Z',  'z' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'y', 'Z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'y', 'Z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'x', 'y', 'Z',  'z' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'Y', 'z',  'x' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'Y', 'z',  'y' ) ) count+=2;
		if( this->ifSmoothSurface1( x, y, z, 'X', 'Y', 'z',  'z' ) ) count+=2;

		if( this->ifSmoothSurface2( x, y, z, 'x', 'y', 'z' ) && this->ifSmoothSurface2( x, y, z, 'X', 'y', 'z' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'x', 'Y', 'z' ) && this->ifSmoothSurface2( x, y, z, 'X', 'Y', 'z' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'x', 'Y', 'Z' ) && this->ifSmoothSurface2( x, y, z, 'X', 'Y', 'Z' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'x', 'y', 'Z' ) && this->ifSmoothSurface2( x, y, z, 'X', 'y', 'Z' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'y', 'z', 'x' ) && this->ifSmoothSurface2( x, y, z, 'Y', 'z', 'x' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'y', 'Z', 'x' ) && this->ifSmoothSurface2( x, y, z, 'Y', 'Z', 'x' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'y', 'Z', 'X' ) && this->ifSmoothSurface2( x, y, z, 'Y', 'Z', 'X' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'y', 'z', 'X' ) && this->ifSmoothSurface2( x, y, z, 'Y', 'z', 'X' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'z', 'x', 'y' ) && this->ifSmoothSurface2( x, y, z, 'Z', 'x', 'y' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'z', 'X', 'y' ) && this->ifSmoothSurface2( x, y, z, 'Z', 'X', 'y' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'z', 'X', 'Y' ) && this->ifSmoothSurface2( x, y, z, 'Z', 'X', 'Y' ) ) count+=2;
		if( this->ifSmoothSurface2( x, y, z, 'z', 'x', 'Y' ) && this->ifSmoothSurface2( x, y, z, 'Z', 'x', 'Y' ) ) count+=2;

		if( this->ifSmoothSurface3( x, y, z, 'x', 'y', 'z' ) ) count++;
		if( this->ifSmoothSurface3( x, y, z, 'x', 'Y', 'z' ) ) count++;
		if( this->ifSmoothSurface3( x, y, z, 'x', 'Y', 'Z' ) ) count++;
		if( this->ifSmoothSurface3( x, y, z, 'x', 'y', 'Z' ) ) count++;
		if( this->ifSmoothSurface3( x, y, z, 'X', 'y', 'z' ) ) count++;
		if( this->ifSmoothSurface3( x, y, z, 'X', 'Y', 'z' ) ) count++;
		if( this->ifSmoothSurface3( x, y, z, 'X', 'Y', 'Z' ) ) count++;
		if( this->ifSmoothSurface3( x, y, z, 'X', 'y', 'Z' ) ) count++;
	}}}
	return count;
}

void CVoxel2::print(){
	for( int y=0; y<ySize; y++ ){
		for( int x=0; x<xSize; x++ ){
			printf("%d ", this->density( x, y ) );
		}
		printf("\n");
	}
}
void CVoxel::print(){
	for( int z=0; z<zSize; z++ ){
		for( int y=0; y<ySize; y++ ){
			for( int x=0; x<xSize; x++ ){
				printf("%d ", this->density( x, y, z ) );
			}
			printf("\n");
		}
		printf("\n");
	}
}
