class CVoxelBodyF2: public CVoxelBody2{
public:
	// for renewal
	void setElasticForce( double youngsModulus, double dampingCoefficient ){//0.047
		for( int j=0; j<elementSize; j++ ){
			if( element[j] ){
				int vertexSize = element[j]->vertexSize;
				CVertex2 *v = element[j]->vertexList[0];
				double cx = v->position.x;
				double cy = v->position.y;
				double cvx = v->velocity.x;
				double cvy = v->velocity.y;
				int i;
				for( i=1; i<vertexSize; i++ ){
					v = element[j]->vertexList[i];
					cx += v->position.x;
					cy += v->position.y;
					cvx += v->velocity.x;
					cvy += v->velocity.y;
				}
				cx /= vertexSize;
				cy /= vertexSize;
				cvx /= vertexSize;
				cvy /= vertexSize;
				double rx[32], ry[32], Rox[32], Roy[32];
				for( i=0; i<vertexSize; i++ ){
					v = element[j]->vertexList[i];
					rx[i] = v->position.x - cx;
					ry[i] = v->position.y - cy;
					Rox[i] = v->R.x;
					Roy[i] = v->R.y;
				}
				double cs = Rox[0] * rx[0] + Roy[0] * ry[0];
				double sn = Rox[0] * ry[0] - Roy[0] * rx[0];
				for( i=1; i<vertexSize; i++ ){
					cs += Rox[i] * rx[i] + Roy[i] * ry[i];
					sn += Rox[i] * ry[i] - Roy[i] * rx[i];
				}
				double l = sqrt( cs*cs + sn*sn );
				if( l < 0.000001 ){
					printf("Error in renewR()!\n");
					return;
				}
				cs /= l;
				sn /= l;
				for( i=0; i<vertexSize; i++ ){
					v = element[j]->vertexList[i];
					v->R.x = cs * Rox[i] - sn *Roy[i];
					v->R.y = sn * Rox[i] + cs *Roy[i];
				}

			//	double squreErrors = 0.0;
			//	for( i=0; i<vertexSize; i++ ) squreErrors += vertexList[i]->addElasticForce( youngsModulus/averageR, dampingCoefficient, centerVelocity );
				double springConstant = youngsModulus/element[j]->averageR;
				for( i=0; i<vertexSize; i++ ){
					v = element[j]->vertexList[i];
					v->acceleration.x = -springConstant*(rx[i]-v->R.x) -dampingCoefficient*(v->velocity.x-cvx);
					v->acceleration.y = -springConstant*(ry[i]-v->R.y) -dampingCoefficient*(v->velocity.y-cvy);
				}
			}
		}
	}
	void adjustAcceleration(){//0.18->0.016
		for( int i=0; i<jointSize; i++ ){
			if( joint[i] && !joint[i]->disconnected ){
				double x=0.0;
				double y=0.0;
				int count = 0;
				int j;
				for( j=0; j<4; j++ ){
					if( CVertex2 *v=joint[i]->vertex[j] ){
						x += v->acceleration.x;
						y += v->acceleration.y;
						count++;
					}
				}
				x /= count;
				y /= count;
				for( j=0; j<4; j++ ) if( CVertex2 *v=joint[i]->vertex[j] ){ v->acceleration.x = x; v->acceleration.y = y; }
			}
		}
	}
	void addGravityAndRenew( double g, double timeStep ){//0.01
		for( int i=0; i<elementSize; i++ ){
			if( element[i] ){
				for( int j=0; j<element[i]->vertexSize; j++ ){
					if( CVertex2 *v=element[i]->vertexList[j] ){
						v->acceleration.y -= g;
						v->velocity.x += timeStep * v->acceleration.x;
						v->velocity.y += timeStep * v->acceleration.y;
						v->position.x += timeStep * v->velocity.x;
						v->position.y += timeStep * v->velocity.y;
					}
				}
			}
		}
	}
};

//-------------------------------------------------------------------------------------------------------------------
class CGradationBodyF2: public CVoxelBodyF2{
public:
};
//-------------------------------------------------------------------------------------------------------------------
class CDestructionBodyF2: public CGradationBodyF2{
public:

	void renew( double gravityConstant, double youngsModulus, double dampingCoefficient, double timeStep, double threshold = -1.0 );
	void disconnect( double threshold );
	void reconstruct( double youngsModulus, double dampingCoefficient );
};


void CDestructionBodyF2::disconnect( double threshold ){//0.225->0.016
	double thresholdXthreshold = threshold*threshold;
	for( int i=0; i<(xSize+1)*(ySize+1); i++ ){
		if( joint[i] ){
			int x= i%(xSize+1);
			int y= i/(xSize+1);
			if( ( x>0 && y>0 && element[elementMarks[0] + x-1 + xSizes[0]*(y-1)] )//0.20->0.19
			|| ( x>0 && y<ySize && element[elementMarks[0] + x-1 + xSizes[0]*(y)] )
			|| ( x<xSize && y>0 && element[elementMarks[0] + x + xSizes[0]*(y-1)] )
			|| ( x<xSize && y<ySize && element[elementMarks[0] + x + xSizes[0]*(y)] ) ){
				if( joint[i]->connect[0] && joint[i]->vertex[0] && joint[i]->vertex[1]){
					CVertex2 *v1 = joint[i]->vertex[0];
					CVertex2 *v2 = joint[i]->vertex[1];
					double x = v2->acceleration.x - v1->acceleration.x;
					double y = v2->acceleration.y - v1->acceleration.y;
					if( x*x+y*y > thresholdXthreshold ){
						joint[i]->connect[0] = false;
						joint[i]->disconnected = true;
					}
				}
				if( joint[i]->connect[1] && joint[i]->vertex[1] && joint[i]->vertex[3]){
					CVertex2 *v1 = joint[i]->vertex[1];
					CVertex2 *v2 = joint[i]->vertex[3];
					double x = v2->acceleration.x - v1->acceleration.x;
					double y = v2->acceleration.y - v1->acceleration.y;
					if( x*x+y*y > thresholdXthreshold ){
						joint[i]->connect[1] = false;
						joint[i]->disconnected = true;
					}
				}
				if( joint[i]->connect[2] && joint[i]->vertex[3] && joint[i]->vertex[2]){
					CVertex2 *v1 = joint[i]->vertex[3];
					CVertex2 *v2 = joint[i]->vertex[2];
					double x = v2->acceleration.x - v1->acceleration.x;
					double y = v2->acceleration.y - v1->acceleration.y;
					if( x*x+y*y > thresholdXthreshold ){
						joint[i]->connect[2] = false;
						joint[i]->disconnected = true;
					}
				}
				if( joint[i]->connect[3] && joint[i]->vertex[2] && joint[i]->vertex[0]){
					CVertex2 *v1 = joint[i]->vertex[2];
					CVertex2 *v2 = joint[i]->vertex[0];
					double x = v2->acceleration.x - v1->acceleration.x;
					double y = v2->acceleration.y - v1->acceleration.y;
					if( x*x+y*y > thresholdXthreshold ){
						joint[i]->connect[3] = false;
						joint[i]->disconnected = true;
					}
				}
			}
		}
	}
}

void CDestructionBodyF2::renew( double gravityConstant, double youngsModulus, double dampingCoefficient, double timeStep, double threshold ){
//	this->setElasticForce( youngsModulus, dampingCoefficient );//0.99(0.03+0.96)->0.047
	if( threshold > 0.0 ){
//		this->disconnect( threshold );//0.225->0.016
		this->reconstruct( youngsModulus, dampingCoefficient );//0.765->0.20
//		this->setElasticForce( youngsModulus, dampingCoefficient );//0.047
	}
	this->adjustAcceleration();//0.18->0.016
//	this->addAcceleration( 0.0, -gravityConstant );//0.35
//	this->renewVelocity( timeStep );
//	this->renewPosition( timeStep );
	this->addGravityAndRenew( gravityConstant, timeStep );//0.35->0.015
}

void CDestructionBodyF2::reconstruct( double youngsModulus, double dampingCoefficient ){//0.765->
	int n = 1;
	for( int level=1; level<levelSize; level++ ){
		n *= 2;
		int u = n/2;

		int y;
		for( y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( element[elementMarks[level] + x+xSizes[level]*y] ){
				CElement2 *e = element[elementMarks[level] + x+xSizes[level]*y];
				if( e->vertex[0] && e->vertex[2] && !e->vertex[1] ) e->vertex[1] = new CVertex2( *e->vertex[0], *e->vertex[2] );
				if( e->vertex[6] && e->vertex[8] && !e->vertex[7] ) e->vertex[7] = new CVertex2( *e->vertex[6], *e->vertex[8] );
				if( e->vertex[0] && e->vertex[6] && !e->vertex[3] ) e->vertex[3] = new CVertex2( *e->vertex[0], *e->vertex[6] );
				if( e->vertex[2] && e->vertex[8] && !e->vertex[5] ) e->vertex[5] = new CVertex2( *e->vertex[2], *e->vertex[8] );
				if( !e->vertex[4] ) e->vertex[4] = new CVertex2( *e->vertex[1], *e->vertex[3], *e->vertex[5], *e->vertex[7] );

				int x2=x*2;
				int y2=y*2;
				int x4=x*4;
				int y4=y*4;

				for( int j=0; j<2; j++ ){
				for( int i=0; i<2; i++ ){
					int i2 = i==0 ? 0 : 2;
					int j2 = j==0 ? 0 : 2;
					int i4 = i==0 ? 0 : 4;
					int j4 = j==0 ? 0 : 4;
					if( e->vertex[i2+j2*3] ){
						CVertex2 *v=e->vertex[i2+j2*3];
						if( level == 1 ){
							if( joint[x2+i2+(xSize+1)*(y2+j2)] && joint[x2+i2+(xSize+1)*(y2+j2)]->disconnected// inside of if statement was not accelerated because it occurs with low frequency.
							||  joint[x2+ 1+(xSize+1)*(y2+j2)] && joint[x2+ 1+(xSize+1)*(y2+j2)]->disconnected
							||  joint[x2+i2+(xSize+1)*(y2+ 1)] && joint[x2+i2+(xSize+1)*(y2+ 1)]->disconnected ){
								CElement2 *e1=element[sn(level-1,x2+i,y2+j)] = new CElement2( *e->vertex[sn33(i,j)], *e->vertex[sn33(i+1,j)],*e->vertex[sn33(i,j+1)],*e->vertex[sn33(i+1,j+1)] );
								CVoxelBody2::registerJoint( e1, x2+i, y2+j );
								e1->setElasticForce( youngsModulus, dampingCoefficient );
								delete v; 
								e->vertex[i2+j2*3] = NULL;
							}
						}else{
							bool mx = element[elementMarks[level-2] + x4+i2-1+xSizes[level-2]*(y4+j2)] || element[elementMarks[level-2] + x4+i2-1+xSizes[level-2]*(y4+j2+1)];
							bool mX = element[elementMarks[level-2] + x4+i2+2+xSizes[level-2]*(y4+j2)] || element[elementMarks[level-2] + x4+i2+2+xSizes[level-2]*(y4+j2+1)];
							bool my = element[elementMarks[level-2] + x4+i2  +xSizes[level-2]*(y4+j2-1)] || element[elementMarks[level-2] + x4+i2+1+xSizes[level-2]*(y4+j2-1)];
							bool mY = element[elementMarks[level-2] + x4+i2  +xSizes[level-2]*(y4+j2+2)] || element[elementMarks[level-2] + x4+i2+1+xSizes[level-2]*(y4+j2+2)];
							if( mx || mX || my || mY ){// inside of if statement was not accelerated because it occurs with low frequency.
								element[sn(level-1,x2+i,y2+j)] = new CElement2( *e->vertex[sn33(i,j)], *e->vertex[sn33(i+1,j)],*e->vertex[sn33(i,j+1)],*e->vertex[sn33(i+1,j+1)], mx, mX, my, mY );
								CGradationBody2::registerJoint( element[sn(level-1,x2+i,y2+j)], x2+i, y2+j, u );
								element[sn(level-1,x2+i,y2+j)]->setElasticForce( youngsModulus, dampingCoefficient );
								e->deleteVertex( sn33(i2,j2) );
							}
						}
					}
				}}
			}
		}}
		for( y=0; y<ySizes[level]; y++ ){
		for( int x=0; x<xSizes[level]; x++ ){
			if( element[elementMarks[level] + x+xSizes[level]*y] ){
				CElement2 *e = element[elementMarks[level] + x+xSizes[level]*y];
				if( !e->vertex[0] && !e->vertex[2] && !e->vertex[6] && !e->vertex[8] ){
					delete e;
					element[elementMarks[level] + x+xSizes[level]*y] = NULL;
				}else{
					int x2=x*2;
					int y2=y*2;

					if( e->vertex[1] ){
						if( !e->vertex[0] && !e->vertex[2]
						|| e->vertex[0] && e->vertex[2] && !element[elementMarks[level-1] + x2+xSizes[level-1]*(y2-1)] && !element[elementMarks[level-1] + x2+1+xSizes[level-1]*(y2-1)] ){
							delete e->vertex[1];
							e->vertex[1] = NULL;
						}
					}
					if( e->vertex[7] ){
						if( !e->vertex[6] && !e->vertex[8]
						|| e->vertex[6] && e->vertex[8] && !element[elementMarks[level-1] + x2+xSizes[level-1]*(y2+2)] && !element[elementMarks[level-1] + x2+1+xSizes[level-1]*(y2+2)] ){
							delete e->vertex[7];
							e->vertex[7] = NULL;
						}
					}
					if( e->vertex[3] ){
						if( !e->vertex[0] && !e->vertex[6]
						|| e->vertex[0] && e->vertex[6] && !element[elementMarks[level-1] + x2-1+xSizes[level-1]*y2] && !element[elementMarks[level-1] + x2-1+xSizes[level-1]*(y2+1)] ){
								delete e->vertex[3];
							e->vertex[3] = NULL;
						}
					}
					if( e->vertex[5] ){
						if( !e->vertex[2] && !e->vertex[8]
						|| e->vertex[2] && e->vertex[8] && !element[elementMarks[level-1] + x2+2+xSizes[level-1]*y2] && !element[elementMarks[level-1] + x2+2+xSizes[level-1]*(y2+1)] ){
							delete e->vertex[5];
							e->vertex[5] = NULL;
						}
					}
					if( e->vertex[0] && e->vertex[2] && e->vertex[6] && e->vertex[8] && e->vertex[4] ){
							delete e->vertex[4];
							e->vertex[4] = NULL;
					}
					int vertexSize = 0;
					if( e->vertex[0] ) e->vertexList[vertexSize++] = e->vertex[0];
					else if(e->vertex[6]) e->vertexList[vertexSize++] = e->vertex[4];
					if( e->vertex[1] ) e->vertexList[vertexSize++] = e->vertex[1];
					if( e->vertex[2] ) e->vertexList[vertexSize++] = e->vertex[2];
					else if(e->vertex[0]) e->vertexList[vertexSize++] = e->vertex[4];
					if( e->vertex[5] ) e->vertexList[vertexSize++] = e->vertex[5];
					if( e->vertex[8] ) e->vertexList[vertexSize++] = e->vertex[8];
					else if(e->vertex[2]) e->vertexList[vertexSize++] = e->vertex[4];
					if( e->vertex[7] ) e->vertexList[vertexSize++] = e->vertex[7];
					if( e->vertex[6] ) e->vertexList[vertexSize++] = e->vertex[6];
					else if(e->vertex[8]) e->vertexList[vertexSize++] = e->vertex[4];
					if( e->vertex[3] ) e->vertexList[vertexSize++] = e->vertex[3];
					e->vertexSize = vertexSize;

					double cx = e->vertexList[0]->positionOrigin.x;
					double cy = e->vertexList[0]->positionOrigin.y;
					int i, j;
					for( i=1; i<vertexSize; i++ ){
						cx += e->vertexList[i]->positionOrigin.x;
						cy += e->vertexList[i]->positionOrigin.y;
					}
					cx /= vertexSize;
					cy /= vertexSize;
					double averageR = 0.0;
					for( i=0; i<vertexSize; i++ ){
						e->vertexList[i]->R.x = e->vertexList[i]->positionOrigin.x - cx;
						e->vertexList[i]->R.y = e->vertexList[i]->positionOrigin.y - cy;
						averageR += sqrt(e->vertexList[i]->R.x*e->vertexList[i]->R.x+e->vertexList[i]->R.y*e->vertexList[i]->R.y);
					}
					e->averageR = averageR / vertexSize;

					//e->setElasticForce( youngsModulus, dampingCoefficient );
					//CGradationBody2::registerJoint( e, x, y, n );
					int xo=x*n;
					int yo=y*n;
					for( j=0; j<2; j++ ){
					for( i=0; i<2; i++ ){
						int i2 = i==0 ? 0 : 2;
						int j2 = j==0 ? 0 : 2;
						if( e->vertex[i2+j2*3] ){
							int k=xo+u*i2+(xSize+1)*(yo+u*j2);
							if( !joint[k] ) joint[k] = new CJoint2();
							joint[k]->vertex[3-i-j*2] = e->vertex[i2+j2*3];
							if(e->vertex[1+j2*3] ){
								k=xo+u+(xSize+1)*(yo+u*j2);
								if( !joint[k] ) joint[k] = new CJoint2();
								joint[k]->vertex[i+(1-j)*2] = e->vertex[1+j2*3];
							}
							if(e->vertex[i2+3] ){
								k=xo+u*i2+(xSize+1)*(yo+u);
								if( !joint[k] ) joint[k] = new CJoint2();
								joint[k]->vertex[1-i+j*2] = e->vertex[i2+3];
							}
							if( e->vertex[4] ){
								k=xo+u+(xSize+1)*(yo+u);
								if( !joint[k] ) joint[k] = new CJoint2();
								joint[k]->vertex[i+j*2] = e->vertex[4];
							}
						}
					}}

				}
			}
		}}
	}
}
