
// parameters
const double GravityConstant = 9.8; // for 10m X 10m world
const double SpringConstant = 10000.0;
const double DampingRatio = 0.99;
const double Epsilon = 0.8;
const double Mu = 0.8;
const double FrameInterval = 0.033;
const int    ResolutionPerCycle = 20;

#include "obstacle.h"
#include "voxeldata.h"
#include "vertex.h"
#include "element.h"
#include "joint.h"
#include "voxelbody.h"
#include "gradation.h"
#include "destruction.h"

#define _2DMODEL
//#define JoystickMode

// object construction
#ifdef _2DMODEL
	const int XSize = 16;
	const int YSize = 16;
	//const int XSize = 50;
	//const int YSize = 50;
	CVoxel2 voxel( "Square", XSize,YSize ); // Square or Round
	//CVoxel2 voxel( "Round", XSize,YSize ); // Square or Round
	CVoxelBody2 *Object = NULL;
	CObstacle2 **Obstacle = NULL;
#else
	const int XSize = 12;
	const int YSize = 12;
	const int ZSize = 12;
	CVoxel voxel( "Sphere", XSize,YSize,ZSize ); // Cube or Sphere
	//CVoxel voxel( "Cube", XSize,YSize,ZSize ); // Cube or Sphere
	CVoxelBody *Object = NULL;
	CObstacle **Obstacle = NULL;
#endif

const double roomSize = XSize * 4.0;

void initialize(){
	if(Object) delete Object;

	if(!Obstacle){
		#ifdef _2DMODEL
			Obstacle = new CObstacle2 *[10];
		#else
			Obstacle = new CObstacle *[10];
		#endif
		for(int i=0; i<10; i++) Obstacle[i] = NULL;
	}

	int j = 0;
	while( Obstacle[j] ){ delete Obstacle[j]; Obstacle[j] = NULL; j++; }

	#ifdef _2DMODEL
	//	Object = new CVoxelBody2( voxel, roomSize*0.5, roomSize*0.5, 30.0 );
	//	Object = new CGradationBody2( voxel, roomSize*0.5, roomSize*0.5, 30.0 );
	//	Object = new CDestructionBody2( voxel, roomSize*0.5, roomSize*0.5, 30.0 );
		Object = new CDestructionBodyF2( voxel, roomSize*0.4, roomSize*0.5, 30.0 );

		Obstacle[0] = new CRigidCylinder2( roomSize*0.75, roomSize*0.2, roomSize*0.04 );
		Obstacle[1] = new CRigidCylinder2(roomSize*0.1, roomSize*0.3,roomSize*0.04);
		Obstacle[2] = new CRigidCylinder2(roomSize*0.4, roomSize*0.3,roomSize*0.04);
		Obstacle[3] = new CRigidCylinder2(roomSize*0.25, roomSize*0.1,roomSize*0.04);
		Obstacle[4] = new CRigidRoom2(0.0, 0.0, roomSize, roomSize);
	#else
	//	Object = new CVoxelBody( voxel, roomSize*0.5, roomSize*0.5, roomSize*0.5, 30.0 );
	//	Object = new CGradationBody( voxel, roomSize*0.5, roomSize*0.5, roomSize*0.5, 30.0 );
		Object = new CDestructionBody( voxel, roomSize*0.3, roomSize*0.5, roomSize*0.05, 0.0 );

		Obstacle[0] = new CRigidCylinder( roomSize*0.8, roomSize*0.5, roomSize*0.2, roomSize*0.03, roomSize );
		Obstacle[1] = new CRigidRoom(0.0, 0.0, 0.0, roomSize, roomSize, roomSize);
	#endif
}

void reshape( int width, int height ){
	og.Viewport( 0, 0, width, height ); 

	#ifdef _2DMODEL //setting up view for 2D
		og.ZBufferOff();
		og.FlatShading();
		og.LightOff();
		og.Ortho2D(0.0, roomSize, 0.0, roomSize);
	#else //setting up view for 3D
		og.ZBufferOn();
		og.GouraudShading();
		og.LightOn(100.0, 100.0, 100.0, 0.7,0.7,0.7, 1.0,1.0,1.0, 0.3,0.3,0.3);
		og.Perspective( 45.0, 1.0, 100000.0);
		og.LookAt( roomSize*0.5, -roomSize*1.0, roomSize*0.5,  roomSize*0.5, 0, roomSize*0.5,  0, 0, 1 ); //eye, center, up
	//	og.RotateEyePosition(mouseX, mouseY);
	#endif
}

ogVector2 reboundForce;
bool renew( double timeStep ){
	Object->renew( GravityConstant, SpringConstant, DampingRatio, timeStep, 12000.0 );//1.91->0.117

/*	const int buffers = 10;
	static ogVector2 *rf = NULL;
	int i;
	if( !rf ){
		rf = new ogVector2[buffers];
		for(i=0; i<buffers; i++) rf[i].set(0.0, 0.0);
	}
	for(i=0; i<buffers-1; i++) rf[i] = rf[i+1];*/
	/*rf[buffers-1] =*/ Object->rebound( Obstacle, Epsilon, Mu, timeStep, SpringConstant*10.0 )*5.0;//1.20->0.039
/*	ogVector2 rft(0.0, 0.0);
	for(i=0; i<buffers; i++) rft += rf[i];

	reboundForce = rft / buffers;
//	reboundForce = rf[buffers-1];
	//reboundForce.print();

#ifndef JoystickMode
#ifdef _2DMODE
	Obstacle[0]->rebound( (CRigidRoom2 *)Obstacle[4] );
#endif
#endif*/
	return true;
}

void display(){
	og.Clear(0,0,0);

	Object->draw( 255, 255, 255 );
	int i=0;
	while( Obstacle[i] ) Obstacle[i++]->draw();
	og.DrawLine(((CRigidCylinder2*)Obstacle[0])->center.x,((CRigidCylinder2*)Obstacle[0])->center.y,
		((CRigidCylinder2*)Obstacle[0])->center.x+reboundForce.x*0.1,((CRigidCylinder2*)Obstacle[0])->center.y+reboundForce.y*0.1,0,255,0);

	og.SwapBuffers();
}

void idle(){
	#ifdef JoystickMode
		static int mouseX=0, mouseY=0;
		int speed = 2;
		if(og.KeyPressed(OGK_GPL_LEFT)) mouseX-=speed;
		if(og.KeyPressed(OGK_GPL_RIGHT)) mouseX+=speed;
		if(og.KeyPressed(OGK_GPL_UP)) mouseY-=speed;
		if(og.KeyPressed(OGK_GPL_DOWN)) mouseY+=speed;
		mouseX = mouseX<0 ? 0 : mouseX>500 ? 500 : mouseX;
		mouseY = mouseY<0 ? 0 : mouseY>500 ? 500 : mouseY;
	/*	if(og.KeyPressed(OGK_GPR_LEFT)) printf("GPR left button pressed\n");
		if(og.KeyPressed(OGK_GPR_RIGHT)) printf("GPR right button pressed\n");
		if(og.KeyPressed(OGK_GPR_UP)) printf("GPR up button pressed\n");
		if(og.KeyPressed(OGK_GPR_DOWN)) printf("GPR down button pressed\n");
		if(og.KeyPressed(OGK_GPR_LEFT)) printf("GPR left button pressed\n");
		if(og.KeyPressed(OGK_GPT_UPPER_LEFT)) printf("GPT upper left triggered\n");
		if(og.KeyPressed(OGK_GPT_UPPER_RIGHT)) printf("GPT upper right triggered\n");
		if(og.KeyPressed(OGK_GPT_LOWER_LEFT)) printf("GPT lower left triggered\n");
		if(og.KeyPressed(OGK_GPT_LOWER_RIGHT)) printf("GPT lower right triggered\n");*/
		ogVector2 world;
		og.Window2World( mouseX, mouseY, world );
		Obstacle[0]->move( world );
	#endif

	const double DTmax = 2.0*PI/sqrt(SpringConstant)/ResolutionPerCycle;
	const double FImax = 0.03;
	static int n = 1;
	double frameInterval = og.GetFrameInterval();
	if( frameInterval < FrameInterval ) n++; else n--;
	if( n == 0 ) n++;
	double DT = frameInterval/n > DTmax ? DTmax : frameInterval/n;
	//n=1000; DT=0.0;
	for(int i=0; i<n; i++) renew( DT );
	//if( og.KeyPressed('t') ) 
	//printf("%3d renewals/frame | %f sec/frame | DT= %f\n",n, frameInterval,DT );
	og.Redisplay();
}	

void motion( int x, int y ){
	#ifdef _2DMODEL
		ogVector2 world;
		og.Window2World( x, y, world );
	#else
		ogLine line;
		ogVector world;
		line = og.CursorLine( x, y );
		world.y = roomSize*0.5;
		world.x = line.direction.x/line.direction.y*(world.y-line.passage.y)+line.passage.x;
		world.z = line.direction.z/line.direction.y*(world.y-line.passage.y)+line.passage.z;
	//	printf("%d %d\n",x,y);
	//	world.print();
	#endif
	#ifndef JoystickMode
		Obstacle[0]->move( world );
	#endif
}

void keyboard( unsigned char key, int x, int y ){
	og.SetKeyState(key,true);
	switch( key ){
		case 's':getchar();break;
		case 'q': exit(0);
	}
}

void menu( int n ){
	switch( n ){
		case 1: exit(0);
		case 2:
			break;
	}
}

void mouse( int button, int state, int x, int y ){
	if( button == OGK_LBUTTON ){
		if( state == OGK_PRESSED  ){ // {^ꂽƂ
			
		}else{ // {^ꂽƂ
			
		}
	}else if( button == OGK_RBUTTON ){
		if( state == OGK_PRESSED  ){ // E{^ꂽƂ
			
		}else{ // E{^ꂽƂ
			
		}
	}
}
