class CVertex2{
public:
	ogVector2 position;
	ogVector2 positionOrigin;
	ogVector2 velocity;
	ogVector2 acceleration;
	ogVector2 R;
	ogVector2 r;

	//for construction
	CVertex2(){ velocity.set( 0.0, 0.0 ); }
	CVertex2( Double x, Double y ){ ogVector2 position( x, y ); this->set( position ); velocity.set( 0.0, 0.0 ); }
	CVertex2( ogVector2 &position ){ this->set( position ); velocity.set( 0.0, 0.0 ); }
	CVertex2( CVertex2 &v ){
		position = v.position;
		positionOrigin = v.positionOrigin;
		velocity = v.velocity;
	}
	CVertex2( CVertex2 &v1, CVertex2 &v2 ){
		position = (v1.position+v2.position)/2.0;
		positionOrigin = (v1.positionOrigin+v2.positionOrigin)/2.0;
		velocity = (v1.velocity+v2.velocity)/2.0;
		acceleration.set(0.0, 0.0);
	}
	CVertex2( CVertex2 &v1, CVertex2 &v2, CVertex2 &v3, CVertex2 &v4 ){
		position = (v1.position+v2.position+v3.position+v4.position)/4.0;
		positionOrigin = (v1.positionOrigin+v2.positionOrigin+v3.positionOrigin+v4.positionOrigin)/4.0;
		velocity = (v1.velocity+v2.velocity+v3.velocity+v4.velocity)/4.0;
		acceleration.set(0.0, 0.0);
	}
	void set( ogVector2 &position ){ positionOrigin = this->position = R = position; }
	void set( Double x, Double y ){ ogVector2 position( x, y ); this->set( position ); }
	void setR( ogVector2 &R ){ this->R = R; }
	void reset(){ position = positionOrigin; velocity.set( 0.0, 0.0 ); }
	void scale( Double x, Double y ){ position.scale(x,y); positionOrigin.scale(x,y); R.scale(x,y); }
	void rotate( ogMatrix2 &matrix ){ if( this==NULL) return; ogVector2 v = position; position = matrix * v; v = positionOrigin; positionOrigin = matrix * v; v = R; R = matrix * v; }
	void translate( Double x, Double y ){ position.add(x,y); positionOrigin.add(x,y); }
	int ifSamePosition( Double x, Double y, Double marginRadius2 = 0.2 ){ ogVector2 v( x, y ); return position.distance2( v ) < marginRadius2 ? 1 : 0; }
	//for renewal
	Double addElasticForce( Double springConstant, Double dampingCoefficient, ogVector2 &centerVelocity ){
		ogVector2 v,v1;
		acceleration -= (v = springConstant*(v1=r-R));
		acceleration -= (v = dampingCoefficient*(v1=velocity-centerVelocity));
		return r.distance2( R );
	}
	void renewVelocity( Double timeStep ){ ogVector2 v; velocity += (v = timeStep * acceleration); }
	void renewPosition( Double timeStep ){ ogVector2 v; position += (v = timeStep * velocity); }
	void rebound( CObstacle2 *obstacle[], Double restitutionCoefficient, Double frictionCoefficient ){ int i=0; while(obstacle[i]) obstacle[i++]->rebound( position, velocity, restitutionCoefficient, frictionCoefficient ); }
};

class CVertex{
public:
	ogVector position;
	ogVector positionOrigin;
	ogVector velocity;
	ogVector acceleration;
	ogVector R;
	ogVector r;

	//for construction
	CVertex(){ velocity.set( 0.0, 0.0, 0.0 ); }
	CVertex( Double x, Double y, Double z ){ ogVector position( x, y, z ); this->set( position ); velocity.set( 0.0, 0.0, 0.0 ); }
	CVertex( ogVector &position ){ this->set( position ); velocity.set( 0.0, 0.0, 0.0 ); }
	CVertex( CVertex &v ){
		position = v.position;
		positionOrigin = v.positionOrigin;
		velocity = v.velocity;
	}
	CVertex( CVertex &v1, CVertex &v2 ){
		position = (v1.position+v2.position)/2.0;
		positionOrigin = (v1.positionOrigin+v2.positionOrigin)/2.0;
		velocity = (v1.velocity+v2.velocity)/2.0;
		acceleration.set(0.0, 0.0, 0.0);
	}
	CVertex( CVertex &v1, CVertex &v2, CVertex &v3, CVertex &v4 ){
		position = (v1.position+v2.position+v3.position+v4.position)/4.0;
		positionOrigin = (v1.positionOrigin+v2.positionOrigin+v3.positionOrigin+v4.positionOrigin)/4.0;
		velocity = (v1.velocity+v2.velocity+v3.velocity+v4.velocity)/4.0;
		acceleration.set(0.0, 0.0, 0.0);
	}
	CVertex( CVertex &v1, CVertex &v2, CVertex &v3, CVertex &v4, CVertex &v5, CVertex &v6 ){
		position = (v1.position+v2.position+v3.position+v4.position+v5.position+v6.position)/6.0;
		positionOrigin = (v1.positionOrigin+v2.positionOrigin+v3.positionOrigin+v4.positionOrigin+v5.positionOrigin+v6.positionOrigin)/6.0;
		velocity = (v1.velocity+v2.velocity+v3.velocity+v4.velocity+v5.velocity+v6.velocity)/6.0;
		acceleration.set(0.0, 0.0, 0.0);
	}
	void set( ogVector &position ){ positionOrigin = this->position = R = position; }
	void set( Double x, Double y, Double z ){ ogVector position( x, y, z ); this->set( position ); }
	void setR( ogVector &R ){ this->R = R; }
	void reset(){ position = positionOrigin; velocity.set( 0.0, 0.0, 0.0 ); }
	void scale( Double x, Double y, Double z ){ position.scale(x,y,z);  positionOrigin.scale(x,y,z); R.scale(x,y,z); }
	void rotate( ogMatrix3 &matrix ){ if( this==NULL) return; ogVector v = position; position = matrix * v; v = positionOrigin; positionOrigin = matrix * v; v = R; R = matrix * v; }
	void translate( Double x, Double y, Double z ){ position.add(x,y,z); positionOrigin.add(x,y,z); }
	int ifSamePosition( Double x, Double y, Double z, Double marginRadius2 = 0.2 ){ ogVector v( x, y, z ); return position.distance2( v ) < marginRadius2 ? 1 : 0; }
	//for renewal
	Double addElasticForce( Double springConstant, Double dampingCoefficient, ogVector &centerVelocity ){
		ogVector v,v1;
		acceleration -= (v = springConstant*(v1=r-R));
		acceleration -= (v = dampingCoefficient*(v1=velocity-centerVelocity));
		return r.distance2( R );
	}
	void renewVelocity( Double timeStep ){ ogVector v; velocity += (v = timeStep * acceleration); }
	void renewPosition( Double timeStep ){ ogVector v; position += (v = timeStep * velocity); }
	void rebound( CObstacle *obstacle[], Double restitutionCoefficient, Double frictionCoefficient ){ int i=0; while(obstacle[i]) obstacle[i++]->rebound( position, velocity, restitutionCoefficient, frictionCoefficient ); }
};
