#include "glck.h"
#include "cube.h"

//--------------------global variables----------------------
const int CubeSize = 2;
CCube Cube[CubeSize];

CView3d View(
	0.0, -50.0, 0.0, //eye position
	0.0,   0.0, 0.0, //center position
	0.0,   0.0, 1.0, //up normal vector
	45.0, 1.0, 10000.0 ); //fovy(deg), near, far
CLight Light( 1000.0, 1000.0, 1000.0, 0.0 );//ݒ
double Intensity = 0.5;
double Ratio = 0.5;

//------------------------event functions------------------------
void initialize(){
	char filename[128];
	for( int i=0; i<CubeSize; i++ ){
		sprintf( filename, "sh0homo.m%03d.cube", i*30 );
		Cube[i].construct( filename, 1000.0, 1.0 );
	}
}

void display(){
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	if( Ratio < 0.01 ) Ratio = 0.01;
	if( Ratio > 0.99 ) Ratio = 0.99;
	int cubeNumber = Ratio * (CubeSize-1);
	double ratio = Ratio * (CubeSize-1) - cubeNumber;

	View.viewport();
	View.perspective();
	View.lookAt();

	Light.enable();
	glEnable( GL_DEPTH_TEST );
	glDisable( GL_TEXTURE_2D );
	glDisable( GL_BLEND );
	Cube[cubeNumber].drawAtoms( ratio, Cube[cubeNumber+1] );
	Cube[cubeNumber].drawBonds( ratio, Cube[cubeNumber+1] );
	Cube[cubeNumber].drawFrame( 255, 255, 255 );

	Light.disable();
	glDisable( GL_DEPTH_TEST );// because texture polygons are rendered in the same plane three times
	glEnable( GL_TEXTURE_2D );
	glEnable( GL_BLEND );
	Cube[cubeNumber].draw( View.center - View.eye, Intensity, ratio, Cube[cubeNumber+1] );

	glutSwapBuffers();
}

void idle(){
	if( View.timedKeyControl( rad(90.0), 1.0 ) ) display();// view control by ten keys and arrow keys
}

void mouse( int button, int state, int x, int y ){
	if( button == GLUT_LEFT_BUTTON ){
		if( state == GLUT_DOWN  ){
			// Left button pressed
		}else{
			// Left button released
		}
	}else if( button == GLUT_RIGHT_BUTTON ){
		if( state == GLUT_DOWN  ){
			// Right button pressed
		}else{
			// Right button released
		}
	}
}

void motion( int x, int y ){
	Intensity = double(y) / View.height;
	Ratio = double(x) / View.width;
	display();
}

void keyboard(unsigned char key, int x, int y){
	switch ( key ) {
		case 'q':exit(0); break;
	}
}

void menu( int n ){
	switch ( n ) {
		case 1:
			exit(0);
		break;
	}
}

void reshape( int w, int h ){
	View.assignViewport( 0, 0, w, h );
}

//------------------------main function------------------------
void main(int argc, char **argv){
	glutInit( &argc, argv );
	glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );
	glutInitWindowSize( 512, 512 ); //window size
	glutCreateWindow( argv[0] ); //title

	glutReshapeFunc( reshape );
	glutDisplayFunc( display );
	glutIdleFunc( idle );
	glutMouseFunc( mouse );
	glutMotionFunc( motion );
	glutKeyboardFunc( keyboard );
	glutCreateMenu( menu );
	glutAddMenuEntry( "Quit", 1 );
	glutAttachMenu( GLUT_RIGHT_BUTTON );
	initialize();

	glutMainLoop();
}
