#ifdef _WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include "glut.h"
//#include <GL/glut.h>
#include "og/og.h"

#include "cube.h"

//--------------------global variables----------------------
const int CubeSize = 2;
CCube Cube[CubeSize];

double Intensity = 0.5;
double Ratio = 0.5;
int mouseX=250, mouseY=250;
double distance=50.0;

//------------------------event functions------------------------

void display(){
	og.Perspective( 45.0, 1.0, 10000.0);
	og.LookAt( 0, -distance, 0,  0, 0, 0,  0, 0, 1 ); //eye, center, up
	og.RotateEyePosition(mouseX, mouseY);
	og.GouraudShading();

	og.Clear(0,0,0);

	int cubeNumber = Ratio * (CubeSize-1);
	double ratio = Ratio * (CubeSize-1) - cubeNumber;
	//printf("%d %f\n",cubeNumber, ratio);

	og.ZBufferOn();
	glDisable( GL_TEXTURE_2D );
	glDisable( GL_BLEND );

	og.LightOff();
	Cube[cubeNumber].drawFrame( 255, 255, 255 );

	og.LightOn(100.0, 100.0, 100.0, 0.7,0.7,0.7, 0.3,0.3,0.3, 0.3,0.3,0.3, 10.0);
	Cube[cubeNumber].drawAtoms( ratio, Cube[cubeNumber+1] );
	Cube[cubeNumber].drawBonds( ratio, Cube[cubeNumber+1] );

	og.ZBufferOff();
	glEnable( GL_TEXTURE_2D );
	glEnable( GL_BLEND );

	Cube[cubeNumber].draw( og.GetViewDirection(), Intensity, ratio, Cube[cubeNumber+1] );

	og.SwapBuffers();
}

void reshape( int width, int height ){
	og.Viewport( 0, 0, width, height );
}

void initialize(){
	char filename[128];
	for( int i=0; i<CubeSize; i++ ){
		sprintf( filename, "data/sh0homo.m%03d.cube", i*30 );
		Cube[i].construct( filename, 1000.0, 1.0 );
	}
}

void idle(){
	og.Redisplay();
}	

void mouse( int button, int state, int x, int y ){
	if( button == OGK_LBUTTON ){
		if( state == OGK_PRESSED  ){ // {^ꂽƂ
			
		}else{ // {^ꂽƂ
			
		}
	}else if( button == OGK_RBUTTON ){
		if( state == OGK_PRESSED  ){ // E{^ꂽƂ
			
		}else{ // E{^ꂽƂ
			
		}
	}
}

void motion( int x, int y ){
	int width, height;
	og.GetViewport(width,height);
	if(og.KeyPressed(' ')){ // space key is down
		Intensity = double(y) / height;
		Ratio = double(x) / width;
		if( Ratio < 0.01 ) Ratio = 0.01;
		if( Ratio > 0.99 ) Ratio = 0.99;
	}else if(og.KeyPressed('z')){
		distance = 100.0*double(y)/height;
	}else{
		mouseX = x;
		mouseY = y;
	}
}

void keyboard( unsigned char key, int x, int y ){
	og.SetKeyState(key,true);
	switch( key ){
		case 'q': exit(0);
	}
}

void keyboardUp( unsigned char key, int x, int y ){
	og.SetKeyState(key,false);
}

void special( int key, int x, int y ){
	og.SetKeyState(key,true);
}

void specialUp( int key, int x, int y ){
	og.SetKeyState(key,false);
}

void menu( int n ){
	switch( n ){
		case 1: exit(0);
		case 2:
			break;
	}
}

int main( int argc, char **argv ){
	glutInit( &argc, argv );
	glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );
	glutInitWindowSize( 500, 500 );
	glutCreateWindow( "sample" );

	glutReshapeFunc( reshape );
	glutDisplayFunc( display );
	glutIdleFunc( idle );
	glutMouseFunc( mouse );
	glutMotionFunc( motion );
	glutKeyboardFunc( keyboard );
	glutKeyboardUpFunc( keyboardUp );
	glutSpecialFunc( special );
	glutSpecialUpFunc( specialUp );
	glutCreateMenu( menu );
	glutAddMenuEntry( "Quit", 1 );
	glutAttachMenu( GLUT_RIGHT_BUTTON );
 
	initialize();
	
	glutMainLoop();
	return 0;
}
