#ifndef _OGBITMAP_H
#define _OGBITMAP_H

// Copyright (c) OpenMedia Lab., 2003-. ver.6/2/2004

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>

unsigned long _readLong( FILE * &fp ){ unsigned char uc[4]; fread(&uc, sizeof(char), 4, fp); return ((uc[3]*256+uc[2])*256+uc[1])*256+uc[0]; }
void _writeLong( unsigned long ul, FILE * &fp ){ unsigned short us[2]; unsigned char uc[4]; us[0] = (unsigned short)ul%65536; us[1] = (unsigned short)ul/65536; uc[0] = us[0]%256; uc[1] = us[0]/256; uc[2]=us[1]%256; uc[3]=us[1]/256; fwrite(&uc, sizeof(char), 4, fp); }
unsigned short _readShort( FILE * &fp ){ unsigned char uc[2]; fread(&uc, sizeof(char), 2, fp); return uc[1]*256+uc[0]; }
void _writeShort( unsigned short us, FILE * &fp ){ unsigned char uc[2]; uc[0] = us % 256; uc[1] = us / 256; fwrite(&uc, sizeof(char), 2, fp); }

int ogLoadBitmap( char filename[], int &width, int &height, int &channel, unsigned char **uc ){
	FILE *fp;
	if( (fp=fopen( filename, "rb" ))==NULL ) return 1;

	char c;
	unsigned long l;
	unsigned short s;
	int offset;
	int dpiH,dpiV;
	fread( &c, sizeof(char), 1, fp ); if( c != 'B' ) return 1;
	fread( &c, sizeof(char), 1, fp ); if( c != 'M' ) return 1;
	l = _readLong( fp ); // file size
	s = _readShort( fp ); // must be 0
	s = _readShort( fp ); // must be 0
	l = _readLong( fp ); offset = l; // offset of image data(==54)
	l = _readLong( fp ); // size of the header(==40)
	l = _readLong( fp ); width = l;
	l = _readLong( fp ); height = l;
	s = _readShort( fp ); // must be 1
	s = _readShort( fp ); channel = s/8;// must be 24 if RGB image
	l = _readLong( fp );  // must be 0
	l = _readLong( fp );  // size of image data(=width*height*3)
	l = _readLong( fp ); dpiH = l/40;// horizontal pixel/meter(=dpiH*40) 
	l = _readLong( fp ); dpiV = l/40; // vertical pixel/meter(=dpiV*40) 
	l = _readLong( fp ); // must be 0
	l = _readLong( fp ); // must be 0
	fseek( fp, offset, SEEK_SET );

	// read image
	*uc = new unsigned char[width*height*channel];
	for(int j=0;j<height;j++){
		for(int i=0;i<width;i++){
			if( channel == 1 ){
				*(*uc+i+width*j) = (unsigned char)(getc(fp));
			}else if( channel == 3 ){
				*(*uc+2+channel*(i+width*j)) = (unsigned char)(getc(fp));
				*(*uc+1+channel*(i+width*j)) = (unsigned char)(getc(fp));
				*(*uc+  channel*(i+width*j)) = (unsigned char)(getc(fp));
			}
		}
		if(width*channel%4) for(int k=0; k<4-width*channel%4; k++) getc(fp);
	}
	fclose( fp );
	return 0;
}

int ogSaveBitmap( char filename[], int width, int height, int channel, unsigned char uc[]  ){
	FILE *fp;
	if( (fp=fopen( filename, "wb" ))==NULL ) return 1;

	char c;
	c = 'B'; fwrite( &c, sizeof(char), 1, fp );
	c = 'M'; fwrite( &c, sizeof(char), 1, fp );
	_writeLong( (width%4 !=0 ? (width/4+1)*4 : width) * height * 3 + 54, fp ); // file size
	_writeShort( 0, fp ); // must be 0
	_writeShort( 0, fp ); // must be 0
	_writeLong( 54, fp ); // offset of image data(==54)
	_writeLong( 40, fp ); // size of the header(==40)
	_writeLong( (unsigned long)width, fp );
	_writeLong( (unsigned long)height, fp );
	_writeShort( 1, fp ); // must be 1
	_writeShort( channel*8, fp ); // must be 24 for RGB image
	_writeLong( 0, fp ); // must be 0
	_writeLong( (width%4 !=0 ? (width/4+1)*4 : width) * height * 3, fp ); // size of image data(=width*height*3)
	_writeLong( 300*40, fp ); // horizontal pixel/meter(=dpiH*40) 
	_writeLong( 300*40, fp ); // vertical pixel/meter(=dpiV*40) 
	_writeLong( 0, fp ); // must be 0
	_writeLong( 0, fp ); // must be 0
	// write image
	unsigned char u;
	if( channel == 1 ) for ( int l=0; l<256; l++ ){
		u = l;
		for ( int k=0; k<4; k++ ) fwrite( &u, sizeof(char), 1, fp );
	}
	for ( int j=0; j<height; j++ ){
		for ( int i=0; i<width; i++ ){
			for ( int c=0; c<channel; c++ ){
				u = uc[channel-1-c+channel*(i+width*j)];
				fwrite( &u, sizeof(char), 1, fp );
			}
		}
		if(width*channel%4) for(int k=0; k<4-width*channel%4; k++){ u = 0; fwrite( &u, sizeof(char), 1, fp ); }
	}
	fclose( fp );
	return 0;
}

void ogDrawPixels(int originX, int originY, int width, int height, int channel, unsigned char uc[]){
#ifdef __GL_H__
	glRasterPos2i( originX, originY );
	if(width%4) glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	if(channel==1){
		glDrawPixels( width, height, GL_LUMINANCE, GL_UNSIGNED_BYTE, uc );
	}else if(channel==3){
		glDrawPixels( width, height, GL_RGB, GL_UNSIGNED_BYTE, uc );
	}
	if(width%4) glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
#else
#endif
}

void ogReadPixels(int originX, int originY, int width, int height, unsigned char uc[]){
#ifdef __GL_H__
	if(width%4) glPixelStorei(GL_PACK_ALIGNMENT, 1);
	glReadPixels(originX, originY, width, height, GL_RGB, GL_UNSIGNED_BYTE, uc );
	if(width%4) glPixelStorei(GL_PACK_ALIGNMENT, 4);
#else
#endif
}

//------------------------------------------------------------------------------------------------
inline unsigned char cramp( int value ){ return value < 0 ? 0 : value > 255 ? 255 : (unsigned char)(value); }
inline unsigned char cramp( double value ){ return value < 0 ? 0 : value > 255 ? 255 : (unsigned char)(value); }

class ogColor{
public:
	unsigned char r;
	unsigned char g;
	unsigned char b;
	unsigned char a;
	void   set( unsigned char r0, unsigned char g0, unsigned char b0, unsigned char a0 = 255 ){ r=r0; g=g0; b=b0; a=a0; }
	ogColor(){};
	ogColor( unsigned char r0, unsigned char g0, unsigned char b0, unsigned char a0 = 255 ){ this->set( r0, g0, b0, a0 ); }
};
//------------------------------------------------------------------------------------------------
class ogUCPointer{
public:
	unsigned char *uc;
	int operator +( ogUCPointer &a ){ return *uc + *a.uc; }
	int operator -( ogUCPointer &a ){ return *uc - *a.uc; }
	int operator *( ogUCPointer &a ){ return *uc * *a.uc; }
	int operator /( ogUCPointer &a ){ return *uc / *a.uc; }
	int operator +( int i ){ return *uc + i; }
	int operator -( int i ){ return *uc - i; }
	int operator *( int i ){ return *uc * i; }
	int operator /( int i ){ return *uc / i; }
	friend int operator +( int i, ogUCPointer &a ){ return i + *a.uc; }
	friend int operator -( int i, ogUCPointer &a ){ return i - *a.uc; }
	friend int operator *( int i, ogUCPointer &a ){ return i * *a.uc; }
	friend int operator /( int i, ogUCPointer &a ){ return i / *a.uc; }
	double operator +( double d ){ return *uc + d; }
	double operator -( double d ){ return *uc - d; }
	double operator *( double d ){ return *uc * d; }
	double operator /( double d ){ return *uc / d; }
	friend double operator +( double d, ogUCPointer &a ){ return d + *a.uc; }
	friend double operator -( double d, ogUCPointer &a ){ return d - *a.uc; }
	friend double operator *( double d, ogUCPointer &a ){ return d * *a.uc; }
	friend double operator /( double d, ogUCPointer &a ){ return d / *a.uc; }
	ogUCPointer operator +=( ogUCPointer &a ){ *uc = cramp(*uc + *a.uc); return *this; }
	ogUCPointer operator -=( ogUCPointer &a ){ *uc = cramp(*uc - *a.uc); return *this; }
	ogUCPointer operator *=( ogUCPointer &a ){ *uc = cramp(*uc * *a.uc); return *this; }
	ogUCPointer operator /=( ogUCPointer &a ){ *uc = cramp(*uc / *a.uc); return *this; }
	ogUCPointer operator +=( int i ){ *uc = cramp(*uc + i); return *this; }
	ogUCPointer operator -=( int i ){ *uc = cramp(*uc - i); return *this; }
	ogUCPointer operator *=( int i ){ *uc = cramp(*uc * i); return *this; }
	ogUCPointer operator /=( int i ){ *uc = cramp(*uc / i); return *this; }
	ogUCPointer operator +=( double d ){ *uc = cramp(*uc + d); return *this; }
	ogUCPointer operator -=( double d ){ *uc = cramp(*uc - d); return *this; }
	ogUCPointer operator *=( double d ){ *uc = cramp(*uc * d); return *this; }
	ogUCPointer operator /=( double d ){ *uc = cramp(*uc / d); return *this; }
	friend int operator +=( int i, ogUCPointer &a ){ return cramp(i + *a.uc); }
	friend int operator -=( int i, ogUCPointer &a ){ return cramp(i - *a.uc); }
	friend int operator *=( int i, ogUCPointer &a ){ return cramp(i * *a.uc); }
	friend int operator /=( int i, ogUCPointer &a ){ return cramp(i / *a.uc); }
	friend double operator +=( double d, ogUCPointer &a ){ return cramp(d + *a.uc); }
	friend double operator -=( double d, ogUCPointer &a ){ return cramp(d - *a.uc); }
	friend double operator *=( double d, ogUCPointer &a ){ return cramp(d * *a.uc); }
	friend double operator /=( double d, ogUCPointer &a ){ return cramp(d / *a.uc); }
	ogUCPointer operator =( ogUCPointer &p ){ *uc = *p.uc; return *this; }
	ogUCPointer operator =( int i ){ *uc = cramp(i); return *this; }
	ogUCPointer operator =( double d ){ *uc = cramp(d); return *this; }
};
double sqrt(ogUCPointer &a){ return sqrt(*a.uc); }

class ogImage {
public:
	unsigned char *array;   // (RGB RGB RGB...) for channel==3
	ogUCPointer *p; //pointer for operator =
	int      width;
	int      height;
	int      channel; // monochrome:1 | RGB:3 | RGBA:4
	int      dpiH;
	int      dpiV;
public:
	void set( int i, int j, int c, unsigned char d ){ array[(i+j*width)*channel+c] = d; }
	void set( int i, int j, unsigned char d ){ array[i+j*width] = d; }
	void set( unsigned char d, int i, int j, int c ){ this->set( i, j, c, d ); }
	void set( unsigned char d, int i, int j ){ this->set( i, j, d ); }
	void set( int i, int j, int d  ){ this->set( i, j, cramp(d) ); }
	void setRed( int i, int j, unsigned char d ){ array[(i+j*width)*channel] = d; }
	void setRed( unsigned char d, int i, int j ){ this->setRed( i, j, d ); }
	void setRed( int i, int j, int d ){ this->setRed( i, j, cramp(d) ); }
	void setGreen( int i, int j, unsigned char d ){ array[(i+j*width)*channel+1] = d; }
	void setGreen( unsigned char d, int i, int j ){ this->setGreen( i, j, d ); }
	void setGreen( int i, int j, int d ){ this->setGreen( i, j, cramp(d) ); }
	void setBlue( int i, int j, unsigned char d ){ array[(i+j*width)*channel+2] = d; }
	void setBlue( unsigned char d, int i, int j ){ this->setBlue( i, j, d ); }
	void setBlue( int i, int j, int d ){ this->setBlue( i, j, cramp(d) ); }
	void set( int i, int j, unsigned char r, unsigned char g, unsigned char b ){ unsigned char *p = &array[(i+j*width)*3]; *p++ = r; *p++ = g; *p = b; }
	void set( int i, int j, int r, int g, int b ){ this->set( i, j, cramp(r), cramp(g), cramp(b) ); }
	void set( int i, int j, unsigned char r, unsigned char g, unsigned char b, unsigned char a ){ unsigned char *p = &array[(i+j*width)*4]; *p++ = r; *p++ = g; *p++ = b; *p = a; }
	unsigned char red( int i, int j ){ return array[(i+j*width)*channel]; }
	unsigned char green( int i, int j ){ return array[(i+j*width)*channel+1]; }
	unsigned char blue( int i, int j ){ return array[(i+j*width)*channel+2]; }
	unsigned char level( int i, int j, int c=0 ){ return array[(i+j*width)*channel+c]; }
	ogUCPointer Red( int i, int j ){ return p[(i+j*width)*channel]; }
	ogUCPointer Green( int i, int j ){ return p[(i+j*width)*channel+1]; }
	ogUCPointer Blue( int i, int j ){ return p[(i+j*width)*channel+2]; }
	ogUCPointer Level( int i, int j, int c=0 ){ return p[(i+j*width)*channel+c]; }
#ifdef __GL_H__
	unsigned long format(){ if(channel==1) return GL_LUMINANCE; else if(channel==4) return GL_RGBA; else return GL_RGB; }
#else
#endif
	void constructPointer(){ if( p != NULL ) delete p; p = new ogUCPointer[width*height*channel]; for(long i=0;i<width*height*channel; i++) p[i].uc = &array[i]; }
	void construct(){ if( array != NULL ) delete array; array = new unsigned char[width*height*channel]; this->constructPointer(); }
	void construct( int w, int h, int c = 1 ){ width=w; height=h; channel=c; this->construct(); }
	void copy( ogImage &image ){ if( image.width != width || image.height != height || image.channel != channel ) this->construct( image.width, image.height, image.channel ); for( long i=0; i<width*height*channel; i++ ) array[i] = image.array[i]; }
	void smooth( ogImage &original, int maskX, int maskY );
	void textureScale();
	void readPixels(int originX, int originY, int width, int height){ this->construct(width, height, 3); ogReadPixels(originX, originY, width, height, array); }
	int load( char *filename ){ int i=ogLoadBitmap(filename, width, height, channel, &array); if(!i) this->constructPointer(); return i; }
	int  save( char *filename ){ return ogSaveBitmap(filename, width, height, channel, array); }
	void draw(int x, int y){ ogDrawPixels(x, y, width, height, channel, array); }
	ogImage( int w, int h, int c = 1 ){ array=NULL; p=NULL; this->construct( w, h, c ); dpiH = dpiV = 300; }
	ogImage( char *filename ){ array=NULL; p=NULL; if( load( filename ) ) printf( "%s not found!\n", filename ); }
	ogImage( ogImage &image ){ array=NULL; p=NULL; this->construct( image.width, image.height, image.channel ); }
	ogImage(void){ array=NULL; p=NULL; }
	~ogImage(){ if( array!= NULL ) delete array; if( p!= NULL ) delete p; }
	void print(){ printf("width %d\nheight %d\nchannel %d\npixel(0,0) %d\n",width, height, channel,array[0]); }
};

void ogImage::smooth( ogImage &original, int maskX, int maskY ){
	this->construct( original.width, original.height, original.channel );
	for( int c=0; c<channel; c++ ){
	  for( int j=0; j<height; j++ ){
		for( int i=0; i<width; i++ ){
			int density = 0;
			int n = 0;
			for( int i1=-maskX/2; i1<=maskX/2; i1++ ){
			for( int j1=-maskY/2; j1<=maskY/2; j1++ ){
				if( i+i1 >=0 && i+i1 <width && j+j1 >=0 && j+j1 <height ){
					density += original.level( i+i1, j+j1, c );
					n++;
				}
			}}
			density /= n;
			this->set( i, j, c, (unsigned char)(density) );
		}
	  }
	}
}

void ogImage::textureScale(){
#ifdef __GL_H__
	int w = 1; while( w <= width ) w *= 2; w /= 2;
	int h = 1; while( h <= height ) h *= 2; h /= 2;
	if( w != width || h != height ){
		ogImage image( w, h, channel );
		gluScaleImage( this->format(), width, height, GL_UNSIGNED_BYTE, array, image.width, image.height, GL_UNSIGNED_BYTE, image.array );
		this->copy( image );
	}
#else
#endif
}

int  ogSaveScreen( char *filename, int originX, int originY, int width, int height ){
	ogImage image;
#ifdef __GL_H__
	image.readPixels(originX, originY, width, height);
	return image.save( filename );
#else
	return 0;
#endif
}
int  ogSaveScreen(char *filename){
#ifdef __GL_H__
	GLint p[4];
	glGetIntegerv( GL_VIEWPORT, p );
	ogImage image;
	image.readPixels(p[0], p[1], p[2], p[3]);
	return image.save( filename );
#else
	return 0;
#endif
}
//#ifdef __GL_H__
//	void readPixels(){ GLint p[4]; glGetIntegerv( GL_VIEWPORT, p ); this->construct(p[2], p[3], 3); this->readPixels(p[0], p[1], width, height); }
//#else
//#endif

#endif //_OGBITMAP_H
